/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.IncrementingEnvironmentEdge;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionObserverBypass {
    private static HBaseTestingUtility util;
    private static final TableName tableName;
    private static final byte[] dummy;
    private static final byte[] row1;
    private static final byte[] row2;
    private static final byte[] row3;
    private static final byte[] test;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessor.class.getName()});
        util = new HBaseTestingUtility(conf);
        util.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = util.getHBaseAdmin();
        if (admin.tableExists(tableName)) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
        util.createTable(tableName, (byte[][])new byte[][]{dummy, test});
    }

    @Test
    public void testSimple() throws Exception {
        HTable t = new HTable(util.getConfiguration(), tableName);
        Put p = new Put(row1);
        p.add(test, dummy, dummy);
        t.put(p);
        this.checkRowAndDelete((Table)t, row1, 0);
        t.close();
    }

    @Test
    public void testMulti() throws Exception {
        EnvironmentEdgeManagerTestHelper.injectEdge((EnvironmentEdge)new IncrementingEnvironmentEdge());
        HTable t = new HTable(util.getConfiguration(), tableName);
        ArrayList<Put> puts = new ArrayList<Put>();
        Put p = new Put(row1);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete((Table)t, row1, 1);
        this.checkRowAndDelete((Table)t, row2, 0);
        this.checkRowAndDelete((Table)t, row3, 0);
        puts.clear();
        p = new Put(row1);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete((Table)t, row1, 0);
        this.checkRowAndDelete((Table)t, row2, 0);
        this.checkRowAndDelete((Table)t, row3, 0);
        puts.clear();
        p = new Put(row1);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete((Table)t, row1, 0);
        this.checkRowAndDelete((Table)t, row2, 0);
        this.checkRowAndDelete((Table)t, row3, 1);
        puts.clear();
        p = new Put(row1);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete((Table)t, row1, 1);
        this.checkRowAndDelete((Table)t, row2, 0);
        this.checkRowAndDelete((Table)t, row3, 1);
        puts.clear();
        p = new Put(row1);
        p.add(test, dummy, dummy);
        puts.add(p);
        p = new Put(row2);
        p.add(dummy, dummy, dummy);
        puts.add(p);
        p = new Put(row3);
        p.add(test, dummy, dummy);
        puts.add(p);
        t.put(puts);
        this.checkRowAndDelete((Table)t, row1, 0);
        this.checkRowAndDelete((Table)t, row2, 1);
        this.checkRowAndDelete((Table)t, row3, 0);
        t.close();
        EnvironmentEdgeManager.reset();
    }

    private void checkRowAndDelete(Table t, byte[] row, int count) throws IOException {
        Get g = new Get(row);
        Result r = t.get(g);
        Assert.assertEquals((int)count, (int)r.size());
        Delete d = new Delete(row);
        t.delete(d);
    }

    static {
        tableName = TableName.valueOf((String)"test");
        dummy = Bytes.toBytes((String)"dummy");
        row1 = Bytes.toBytes((String)"r1");
        row2 = Bytes.toBytes((String)"r2");
        row3 = Bytes.toBytes((String)"r3");
        test = Bytes.toBytes((String)"test");
    }

    public static class TestCoprocessor
    extends BaseRegionObserver {
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            NavigableMap familyMap = put.getFamilyCellMap();
            if (familyMap.containsKey(test)) {
                e.bypass();
            }
        }
    }
}

