/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.log;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.log.LogLevel;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.net.NetUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestLogLevel {
    static final PrintStream out = System.out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testDynamicLogLevel() throws Exception {
        String logName = TestLogLevel.class.getName();
        Log testlog = LogFactory.getLog((String)logName);
        if (testlog instanceof Log4JLogger) {
            Logger log = ((Log4JLogger)testlog).getLogger();
            log.debug((Object)"log.debug1");
            log.info((Object)"log.info1");
            log.error((Object)"log.error1");
            Assert.assertTrue((!Level.ERROR.equals((Object)log.getEffectiveLevel()) ? 1 : 0) != 0);
            HttpServer server = null;
            try {
                String line;
                server = new HttpServer.Builder().setName("..").addEndpoint(new URI("http://localhost:0")).setFindPort(true).build();
                server.start();
                String authority = NetUtils.getHostPortString((InetSocketAddress)server.getConnectorAddress(0));
                URL url = new URL("http://" + authority + "/logLevel?log=" + logName + "&level=" + Level.ERROR);
                out.println("*** Connecting to " + url);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.connect();
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = in.readLine()) != null) {
                    out.println(line);
                }
                in.close();
                connection.disconnect();
                log.debug((Object)"log.debug2");
                log.info((Object)"log.info2");
                log.error((Object)"log.error2");
                Assert.assertTrue((boolean)Level.ERROR.equals((Object)log.getEffectiveLevel()));
                String[] args = new String[]{"-setlevel", authority, logName, Level.DEBUG.toString()};
                LogLevel.main((String[])args);
                log.debug((Object)"log.debug3");
                log.info((Object)"log.info3");
                log.error((Object)"log.error3");
                Assert.assertTrue((boolean)Level.DEBUG.equals((Object)log.getEffectiveLevel()));
            }
            finally {
                if (server != null) {
                    server.stop();
                }
            }
        } else {
            out.println(testlog.getClass() + " not tested.");
        }
    }
}

