/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.WALInputFormat;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTableMapReduceUtil {
    @Test
    public void testInitTableMapperJob1() throws Exception {
        Configuration configuration = new Configuration();
        Job job = new Job(configuration, "tableName");
        TableMapReduceUtil.initTableMapperJob((String)"Table", (Scan)new Scan(), Import.Importer.class, Text.class, Text.class, (Job)job, (boolean)false, WALInputFormat.class);
        Assert.assertEquals(WALInputFormat.class, (Object)job.getInputFormatClass());
        Assert.assertEquals(Import.Importer.class, (Object)job.getMapperClass());
        Assert.assertEquals(LongWritable.class, (Object)job.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)job.getOutputValueClass());
        Assert.assertNull((Object)job.getCombinerClass());
        Assert.assertEquals((Object)"Table", (Object)job.getConfiguration().get("hbase.mapreduce.inputtable"));
    }

    @Test
    public void testInitTableMapperJob2() throws Exception {
        Configuration configuration = new Configuration();
        Job job = new Job(configuration, "tableName");
        TableMapReduceUtil.initTableMapperJob((byte[])Bytes.toBytes((String)"Table"), (Scan)new Scan(), Import.Importer.class, Text.class, Text.class, (Job)job, (boolean)false, WALInputFormat.class);
        Assert.assertEquals(WALInputFormat.class, (Object)job.getInputFormatClass());
        Assert.assertEquals(Import.Importer.class, (Object)job.getMapperClass());
        Assert.assertEquals(LongWritable.class, (Object)job.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)job.getOutputValueClass());
        Assert.assertNull((Object)job.getCombinerClass());
        Assert.assertEquals((Object)"Table", (Object)job.getConfiguration().get("hbase.mapreduce.inputtable"));
    }

    @Test
    public void testInitTableMapperJob3() throws Exception {
        Configuration configuration = new Configuration();
        Job job = new Job(configuration, "tableName");
        TableMapReduceUtil.initTableMapperJob((byte[])Bytes.toBytes((String)"Table"), (Scan)new Scan(), Import.Importer.class, Text.class, Text.class, (Job)job);
        Assert.assertEquals(TableInputFormat.class, (Object)job.getInputFormatClass());
        Assert.assertEquals(Import.Importer.class, (Object)job.getMapperClass());
        Assert.assertEquals(LongWritable.class, (Object)job.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)job.getOutputValueClass());
        Assert.assertNull((Object)job.getCombinerClass());
        Assert.assertEquals((Object)"Table", (Object)job.getConfiguration().get("hbase.mapreduce.inputtable"));
    }

    @Test
    public void testInitTableMapperJob4() throws Exception {
        Configuration configuration = new Configuration();
        Job job = new Job(configuration, "tableName");
        TableMapReduceUtil.initTableMapperJob((byte[])Bytes.toBytes((String)"Table"), (Scan)new Scan(), Import.Importer.class, Text.class, Text.class, (Job)job, (boolean)false);
        Assert.assertEquals(TableInputFormat.class, (Object)job.getInputFormatClass());
        Assert.assertEquals(Import.Importer.class, (Object)job.getMapperClass());
        Assert.assertEquals(LongWritable.class, (Object)job.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)job.getOutputValueClass());
        Assert.assertNull((Object)job.getCombinerClass());
        Assert.assertEquals((Object)"Table", (Object)job.getConfiguration().get("hbase.mapreduce.inputtable"));
    }
}

