/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;

public class MockStoreFile
extends StoreFile {
    long length = 0L;
    boolean isRef = false;
    long ageInDisk;
    long sequenceid;
    private Map<byte[], byte[]> metadata = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    byte[] splitPoint = null;
    TimeRangeTracker timeRangeTracker;
    long entryCount;

    MockStoreFile(HBaseTestingUtility testUtil, Path testPath, long length, long ageInDisk, boolean isRef, long sequenceid) throws IOException {
        super(testUtil.getTestFileSystem(), testPath, testUtil.getConfiguration(), new CacheConfig(testUtil.getConfiguration()), BloomType.NONE);
        this.length = length;
        this.isRef = isRef;
        this.ageInDisk = ageInDisk;
        this.sequenceid = sequenceid;
    }

    void setLength(long newLen) {
        this.length = newLen;
    }

    byte[] getFileSplitPoint(KeyValue.KVComparator comparator) throws IOException {
        return this.splitPoint;
    }

    public long getMaxSequenceId() {
        return this.sequenceid;
    }

    public boolean isMajorCompaction() {
        return false;
    }

    public boolean isReference() {
        return this.isRef;
    }

    boolean isBulkLoadResult() {
        return false;
    }

    public byte[] getMetadataValue(byte[] key) {
        return this.metadata.get(key);
    }

    public void setMetadataValue(byte[] key, byte[] value) {
        this.metadata.put(key, value);
    }

    void setTimeRangeTracker(TimeRangeTracker timeRangeTracker) {
        this.timeRangeTracker = timeRangeTracker;
    }

    void setEntries(long entryCount) {
        this.entryCount = entryCount;
    }

    public StoreFile.Reader getReader() {
        final long len = this.length;
        final TimeRangeTracker timeRange = this.timeRangeTracker;
        final long entries = this.entryCount;
        return new StoreFile.Reader(){

            public long length() {
                return len;
            }

            public long getMaxTimestamp() {
                return timeRange == null ? Long.MAX_VALUE : timeRange.maximumTimestamp;
            }

            public long getEntries() {
                return entries;
            }
        };
    }
}

