/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LoadTestTool;
import org.apache.hadoop.hbase.util.MultiThreadedUpdater;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class MultiThreadedUpdaterWithACL
extends MultiThreadedUpdater {
    private static final Log LOG = LogFactory.getLog(MultiThreadedUpdaterWithACL.class);
    private static final String COMMA = ",";
    private User userOwner;
    private Map<String, Table> userVsTable = new HashMap<String, Table>();
    private Map<String, User> users = new HashMap<String, User>();
    private String[] userNames;

    public MultiThreadedUpdaterWithACL(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, double updatePercent, User userOwner, String userNames) throws IOException {
        super(dataGen, conf, tableName, updatePercent);
        this.userOwner = userOwner;
        this.userNames = userNames.split(COMMA);
    }

    @Override
    protected void addUpdaterThreads(int numThreads) throws IOException {
        for (int i = 0; i < numThreads; ++i) {
            HBaseUpdaterThreadWithACL updater = new HBaseUpdaterThreadWithACL(i);
            this.updaters.add(updater);
        }
    }

    public class HBaseUpdaterThreadWithACL
    extends MultiThreadedUpdater.HBaseUpdaterThread {
        private Table table;
        private MutateAccessAction mutateAction;

        public HBaseUpdaterThreadWithACL(int updaterId) throws IOException {
            super(MultiThreadedUpdaterWithACL.this, updaterId);
            this.mutateAction = new MutateAccessAction();
        }

        @Override
        protected HTableInterface createTable() throws IOException {
            return null;
        }

        @Override
        protected void closeHTable() {
            try {
                if (this.table != null) {
                    this.table.close();
                }
                for (Table table : MultiThreadedUpdaterWithACL.this.userVsTable.values()) {
                    try {
                        table.close();
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error while closing the table " + table.getName()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error while closing the HTable " + this.table.getName()), (Throwable)e);
            }
        }

        @Override
        protected Result getRow(final Get get, final long rowKeyBase, final byte[] cf) {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Result res = null;
                    HTable localTable = null;
                    try {
                        int mod = (int)rowKeyBase % MultiThreadedUpdaterWithACL.this.userNames.length;
                        if (MultiThreadedUpdaterWithACL.this.userVsTable.get(MultiThreadedUpdaterWithACL.this.userNames[mod]) == null) {
                            localTable = new HTable(MultiThreadedUpdaterWithACL.this.conf, MultiThreadedUpdaterWithACL.this.tableName);
                            MultiThreadedUpdaterWithACL.this.userVsTable.put(MultiThreadedUpdaterWithACL.this.userNames[mod], localTable);
                            res = localTable.get(get);
                        } else {
                            localTable = (Table)MultiThreadedUpdaterWithACL.this.userVsTable.get(MultiThreadedUpdaterWithACL.this.userNames[mod]);
                            res = localTable.get(get);
                        }
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("Failed to get the row for key = [" + get.getRow() + "], column family = [" + Bytes.toString((byte[])cf) + "]"), (Throwable)ie);
                    }
                    return res;
                }
            };
            if (MultiThreadedUpdaterWithACL.this.userNames != null && MultiThreadedUpdaterWithACL.this.userNames.length > 0) {
                int mod = (int)rowKeyBase % MultiThreadedUpdaterWithACL.this.userNames.length;
                try {
                    User user;
                    if (!MultiThreadedUpdaterWithACL.this.users.containsKey(MultiThreadedUpdaterWithACL.this.userNames[mod])) {
                        UserGroupInformation realUserUgi = User.isHBaseSecurityEnabled((Configuration)MultiThreadedUpdaterWithACL.this.conf) ? LoadTestTool.loginAndReturnUGI(MultiThreadedUpdaterWithACL.this.conf, MultiThreadedUpdaterWithACL.this.userNames[mod]) : UserGroupInformation.createRemoteUser((String)MultiThreadedUpdaterWithACL.this.userNames[mod]);
                        user = User.create((UserGroupInformation)realUserUgi);
                        MultiThreadedUpdaterWithACL.this.users.put(MultiThreadedUpdaterWithACL.this.userNames[mod], user);
                    } else {
                        user = (User)MultiThreadedUpdaterWithACL.this.users.get(MultiThreadedUpdaterWithACL.this.userNames[mod]);
                    }
                    Result result = (Result)user.runAs((PrivilegedExceptionAction)action);
                    return result;
                }
                catch (Exception ie) {
                    LOG.warn((Object)("Failed to get the row for key = [" + get.getRow() + "], column family = [" + Bytes.toString((byte[])cf) + "]"), (Throwable)ie);
                }
            }
            return null;
        }

        @Override
        public void mutate(Table table, Mutation m, long keyBase, byte[] row, byte[] cf, byte[] q, byte[] v) {
            long start = System.currentTimeMillis();
            try {
                m = MultiThreadedUpdaterWithACL.this.dataGenerator.beforeMutate(keyBase, m);
                this.mutateAction.setMutation(m);
                this.mutateAction.setCF(cf);
                this.mutateAction.setRow(row);
                this.mutateAction.setQualifier(q);
                this.mutateAction.setValue(v);
                this.mutateAction.setStartTime(start);
                this.mutateAction.setKeyBase(keyBase);
                MultiThreadedUpdaterWithACL.this.userOwner.runAs((PrivilegedExceptionAction)this.mutateAction);
            }
            catch (IOException e) {
                this.recordFailure(m, keyBase, start, e);
            }
            catch (InterruptedException e) {
                MultiThreadedUpdaterWithACL.this.failedKeySet.add(keyBase);
            }
        }

        private void recordFailure(Mutation m, long keyBase, long start, IOException e) {
            String exceptionInfo;
            MultiThreadedUpdaterWithACL.this.failedKeySet.add(keyBase);
            if (e instanceof RetriesExhaustedWithDetailsException) {
                RetriesExhaustedWithDetailsException aggEx = (RetriesExhaustedWithDetailsException)((Object)e);
                exceptionInfo = aggEx.getExhaustiveDescription();
            } else {
                StringWriter stackWriter = new StringWriter();
                PrintWriter pw = new PrintWriter(stackWriter);
                e.printStackTrace(pw);
                pw.flush();
                exceptionInfo = StringUtils.stringifyException((Throwable)e);
            }
            LOG.error((Object)("Failed to mutate: " + keyBase + " after " + (System.currentTimeMillis() - start) + "ms; region information: " + MultiThreadedUpdaterWithACL.this.getRegionDebugInfoSafe(this.table, m.getRow()) + "; errors: " + exceptionInfo));
        }

        class MutateAccessAction
        implements PrivilegedExceptionAction<Object> {
            private Table table;
            private long start;
            private Mutation m;
            private long keyBase;
            private byte[] row;
            private byte[] cf;
            private byte[] q;
            private byte[] v;

            public void setStartTime(long start) {
                this.start = start;
            }

            public void setMutation(Mutation m) {
                this.m = m;
            }

            public void setRow(byte[] row) {
                this.row = row;
            }

            public void setCF(byte[] cf) {
                this.cf = cf;
            }

            public void setQualifier(byte[] q) {
                this.q = q;
            }

            public void setValue(byte[] v) {
                this.v = v;
            }

            public void setKeyBase(long keyBase) {
                this.keyBase = keyBase;
            }

            @Override
            public Object run() throws Exception {
                try {
                    if (this.table == null) {
                        this.table = new HTable(MultiThreadedUpdaterWithACL.this.conf, MultiThreadedUpdaterWithACL.this.tableName);
                    }
                    if (this.m instanceof Increment) {
                        this.table.increment((Increment)this.m);
                    } else if (this.m instanceof Append) {
                        this.table.append((Append)this.m);
                    } else if (this.m instanceof Put) {
                        this.table.checkAndPut(this.row, this.cf, this.q, this.v, (Put)this.m);
                    } else if (this.m instanceof Delete) {
                        this.table.checkAndDelete(this.row, this.cf, this.q, this.v, (Delete)this.m);
                    } else {
                        throw new IllegalArgumentException("unsupported mutation " + this.m.getClass().getSimpleName());
                    }
                    MultiThreadedUpdaterWithACL.this.totalOpTimeMs.addAndGet(System.currentTimeMillis() - this.start);
                }
                catch (IOException e) {
                    HBaseUpdaterThreadWithACL.this.recordFailure(this.m, this.keyBase, this.start, e);
                }
                return null;
            }
        }
    }
}

