/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
public class FaultyFSLog
extends FSHLog {
    FailureType ft = FailureType.NONE;

    public FaultyFSLog(FileSystem fs, Path rootDir, String logName, Configuration conf) throws IOException {
        super(fs, rootDir, logName, conf);
    }

    public void setFailureType(FailureType fType) {
        this.ft = fType;
    }

    public void sync(long txid) throws IOException {
        if (this.ft == FailureType.SYNC) {
            throw new IOException("sync");
        }
        super.sync(txid);
    }

    public long append(HTableDescriptor htd, HRegionInfo info, WALKey key, WALEdit edits, boolean inMemstore) throws IOException {
        if (this.ft == FailureType.APPEND) {
            throw new IOException("append");
        }
        return super.append(htd, info, key, edits, inMemstore);
    }

    public static enum FailureType {
        NONE,
        APPEND,
        SYNC;

    }
}

