/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.Serializable;
import java.util.BitSet;

public final class ConvertableBitSet
implements Cloneable,
Serializable {
    private BitSet theBits;

    public ConvertableBitSet() {
        this.theBits = new BitSet();
    }

    public ConvertableBitSet(int n) {
        this.theBits = new BitSet(n);
    }

    public void and(BitSet bitSet) {
        this.theBits.and(bitSet);
    }

    public void and(ConvertableBitSet convertableBitSet) {
        this.theBits.and(convertableBitSet.theBits);
    }

    public void clear(int n) {
        this.theBits.clear(n);
    }

    public Object clone() {
        try {
            ConvertableBitSet convertableBitSet = (ConvertableBitSet)super.clone();
            convertableBitSet.theBits = (BitSet)this.theBits.clone();
            return convertableBitSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ConvertableBitSet) {
            return this.theBits.equals(((ConvertableBitSet)object).theBits);
        }
        return this.theBits.equals(object);
    }

    public static ConvertableBitSet fromDouble(double d) {
        return ConvertableBitSet.fromLong(Double.doubleToLongBits(d));
    }

    public static ConvertableBitSet fromFloat(float f) {
        return ConvertableBitSet.fromInt(Float.floatToIntBits(f));
    }

    public static ConvertableBitSet fromInt(int n) {
        return ConvertableBitSet.fromString(Integer.toBinaryString(n));
    }

    public static ConvertableBitSet fromLong(long l) {
        return ConvertableBitSet.fromString(Long.toBinaryString(l));
    }

    public static ConvertableBitSet fromString(String string) {
        ConvertableBitSet convertableBitSet = new ConvertableBitSet(string.length());
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(string.length() - n - 1) == '1') {
                convertableBitSet.set(n);
            }
            ++n;
        }
        return convertableBitSet;
    }

    public boolean get(int n) {
        return this.theBits.get(n);
    }

    public int hashCode() {
        return this.theBits.hashCode();
    }

    public void or(BitSet bitSet) {
        this.theBits.or(bitSet);
    }

    public void or(ConvertableBitSet convertableBitSet) {
        this.theBits.or(convertableBitSet.theBits);
    }

    public void set(int n) {
        this.theBits.set(n);
    }

    public int size() {
        return this.theBits.size();
    }

    public double toDouble() {
        return Double.longBitsToDouble(this.toLong());
    }

    public String toDoubleString() {
        String string = this.toString(64);
        String string2 = ",";
        return String.valueOf(string.substring(0, 1)) + "," + string.substring(1, 12) + "," + string.substring(12);
    }

    public float toFloat() {
        return Float.intBitsToFloat(this.toInt());
    }

    public String toFloatString() {
        String string = this.toString(32);
        String string2 = ",";
        return String.valueOf(string.substring(0, 1)) + "," + string.substring(1, 9) + "," + string.substring(9);
    }

    public int toInt() {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 32) {
            if (this.theBits.get(n3)) {
                n += n2;
            }
            n2 <<= 1;
            ++n3;
        }
        return n;
    }

    public int toLong() {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 64) {
            if (this.theBits.get(n3)) {
                n += n2;
            }
            n2 <<= 1;
            ++n3;
        }
        return n;
    }

    public String toString() {
        int n = this.theBits.size();
        while (n >= 0) {
            if (this.theBits.get(n)) {
                return this.toString(n + 2);
            }
            --n;
        }
        return "00";
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.theBits.get(n2)) {
                stringBuffer.append('1');
            } else {
                stringBuffer.append('0');
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    public void xor(BitSet bitSet) {
        this.theBits.xor(bitSet);
    }

    public void xor(ConvertableBitSet convertableBitSet) {
        this.theBits.xor(convertableBitSet.theBits);
    }
}

