/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.server;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class InclusiveByteRange {
    private static final Logger LOG = Log.getLogger(InclusiveByteRange.class);
    private long first;
    private long last;

    public InclusiveByteRange(long first2, long last) {
        this.first = first2;
        this.last = last;
    }

    public long getFirst() {
        return this.first;
    }

    public long getLast() {
        return this.last;
    }

    private void coalesce(InclusiveByteRange r) {
        this.first = Math.min(this.first, r.first);
        this.last = Math.max(this.last, r.last);
    }

    private boolean overlaps(InclusiveByteRange range2) {
        return range2.first >= this.first && range2.first <= this.last || range2.last >= this.first && range2.last <= this.last || range2.first < this.first && range2.last > this.last;
    }

    public long getSize() {
        return this.last - this.first + 1L;
    }

    public String toHeaderRangeString(long size) {
        StringBuilder sb = new StringBuilder(40);
        sb.append("bytes ");
        sb.append(this.first);
        sb.append('-');
        sb.append(this.last);
        sb.append("/");
        sb.append(size);
        return sb.toString();
    }

    public int hashCode() {
        return (int)(this.first ^ this.last);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InclusiveByteRange)) {
            return false;
        }
        return ((InclusiveByteRange)obj).first == this.first && ((InclusiveByteRange)obj).last == this.last;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append(this.first);
        sb.append(":");
        sb.append(this.last);
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<InclusiveByteRange> satisfiableRanges(Enumeration<String> headers2, long size) {
        ArrayList<InclusiveByteRange> ranges = null;
        long end = size - 1L;
        block4: while (headers2.hasMoreElements()) {
            String header = headers2.nextElement();
            StringTokenizer tok = new StringTokenizer(header, "=,", false);
            String t = null;
            try {
                while (true) {
                    if (!tok.hasMoreTokens()) continue block4;
                    try {
                        t = tok.nextToken().trim();
                        if ("bytes".equals(t)) continue;
                        long first2 = -1L;
                        long last = -1L;
                        int dash = t.indexOf(45);
                        if (dash < 0 || t.indexOf("-", dash + 1) >= 0) {
                            LOG.warn("Bad range format: {}", t);
                            continue block4;
                        }
                        if (dash > 0) {
                            first2 = Long.parseLong(t.substring(0, dash).trim());
                        }
                        if (dash < t.length() - 1) {
                            last = Long.parseLong(t.substring(dash + 1).trim());
                        }
                        if (first2 == -1L) {
                            if (last == -1L) {
                                LOG.warn("Bad range format: {}", t);
                                continue block4;
                            }
                            if (last == 0L) continue;
                            first2 = Math.max(0L, size - last);
                            last = end;
                        } else {
                            if (first2 >= size) continue;
                            if (last == -1L) {
                                last = end;
                            } else if (last >= end) {
                                last = end;
                            }
                        }
                        if (last < first2) {
                            LOG.warn("Bad range format: {}", t);
                            continue block4;
                        }
                        InclusiveByteRange range2 = new InclusiveByteRange(first2, last);
                        if (ranges == null) {
                            ranges = new ArrayList<InclusiveByteRange>();
                        }
                        boolean coalesced = false;
                        ListIterator i = ranges.listIterator();
                        while (i.hasNext()) {
                            InclusiveByteRange r = (InclusiveByteRange)i.next();
                            if (!range2.overlaps(r)) continue;
                            coalesced = true;
                            r.coalesce(range2);
                            while (i.hasNext()) {
                                InclusiveByteRange r2 = (InclusiveByteRange)i.next();
                                if (!r2.overlaps(r)) continue;
                                r.coalesce(r2);
                                i.remove();
                            }
                        }
                        if (coalesced) continue;
                        ranges.add(range2);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("Bad range format: {}", t);
                        LOG.ignore(e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Bad range format: {}", t);
                LOG.ignore(e);
                continue;
            }
            break;
        }
        return ranges;
    }

    public static String to416HeaderRangeString(long size) {
        StringBuilder sb = new StringBuilder(40);
        sb.append("bytes */");
        sb.append(size);
        return sb.toString();
    }
}

