/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Shell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGenericOptionsParser {
    File testDir;
    Configuration conf;
    FileSystem localFs;

    @Test
    public void testFilesOption() throws Exception {
        File tmpFile = new File(this.testDir, "tmpfile");
        Path tmpPath = new Path(tmpFile.toString());
        this.localFs.create(tmpPath);
        String[] args = new String[]{"-files", tmpFile.toURI().toString()};
        new GenericOptionsParser(this.conf, args);
        String files = this.conf.get("tmpfiles");
        Assert.assertNotNull((String)"files is null", (Object)files);
        Assert.assertEquals((String)"files option does not match", (Object)this.localFs.makeQualified(tmpPath).toString(), (Object)files);
        Configuration conf1 = new Configuration();
        URI tmpURI = new URI(tmpFile.toURI().toString() + "#link");
        args[0] = "-files";
        args[1] = tmpURI.toString();
        new GenericOptionsParser(conf1, args);
        files = conf1.get("tmpfiles");
        Assert.assertNotNull((String)"files is null", (Object)files);
        Assert.assertEquals((String)"files option does not match", (Object)this.localFs.makeQualified(new Path(tmpURI)).toString(), (Object)files);
        Configuration conf2 = new Configuration();
        args[0] = "-files";
        args[1] = "file:///xyz.txt";
        Exception th = null;
        try {
            new GenericOptionsParser(conf2, args);
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertNotNull((String)"throwable is null", (Object)th);
        Assert.assertTrue((String)"FileNotFoundException is not thrown", (boolean)(th instanceof FileNotFoundException));
        files = conf2.get("tmpfiles");
        Assert.assertNull((String)"files is not null", (Object)files);
    }

    @Test
    public void testLibjarsOption() throws Exception {
        File tmpJar = new File(this.testDir, "tmp.jar");
        Path tmpJarPath = new Path(tmpJar.toString());
        this.localFs.create(tmpJarPath);
        String[] args = new String[]{"-libjars", tmpJar.toURI().toString()};
        new GenericOptionsParser(this.conf, args);
        String libjars = this.conf.get("tmpjars");
        Assert.assertNotNull((String)"libjars is null", (Object)libjars);
        Assert.assertEquals((String)"libjars does not match", (Object)this.localFs.makeQualified(tmpJarPath).toString(), (Object)libjars);
        args[1] = this.testDir.toURI().toString() + "*";
        new GenericOptionsParser(this.conf, args);
        libjars = this.conf.get("tmpjars");
        Assert.assertNotNull((String)"libjars is null", (Object)libjars);
        Assert.assertEquals((String)"libjars does not match", (Object)this.localFs.makeQualified(tmpJarPath).toString(), (Object)libjars);
    }

    @Test
    public void testEmptyFilenames() throws Exception {
        ArrayList<Pair> argsAndConfNames = new ArrayList<Pair>();
        argsAndConfNames.add(new Pair((Object)"-libjars", (Object)"tmpjars"));
        argsAndConfNames.add(new Pair((Object)"-files", (Object)"tmpfiles"));
        argsAndConfNames.add(new Pair((Object)"-archives", (Object)"tmparchives"));
        for (Pair argAndConfName : argsAndConfNames) {
            String arg = (String)argAndConfName.getFirst();
            File tmpFileOne = new File(this.testDir, "tmpfile1");
            Path tmpPathOne = new Path(tmpFileOne.toString());
            File tmpFileTwo = new File(this.testDir, "tmpfile2");
            Path tmpPathTwo = new Path(tmpFileTwo.toString());
            this.localFs.create(tmpPathOne);
            this.localFs.create(tmpPathTwo);
            String[] args = new String[]{arg, String.format("%s,,%s", tmpFileOne.toURI().toString(), tmpFileTwo.toURI().toString())};
            try {
                new GenericOptionsParser(this.conf, args);
                Assert.fail((String)"Expected exception for empty filename");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains("File name can't be empty string", e);
            }
            args[1] = ",,";
            try {
                new GenericOptionsParser(this.conf, args);
                Assert.fail((String)"Expected exception for zero file list length");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains("File name can't be empty string", e);
            }
            args[1] = String.format("%s, ,%s", tmpFileOne.toURI().toString(), tmpFileTwo.toURI().toString());
            try {
                new GenericOptionsParser(this.conf, args);
                Assert.fail((String)"Expected exception for filename with space character");
            }
            catch (IllegalArgumentException e) {
                GenericTestUtils.assertExceptionContains("URISyntaxException", e);
            }
        }
    }

    @Test
    public void testCreateWithOptions() throws Exception {
        OptionBuilder.withArgName((String)"int");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"A new option");
        Option opt = OptionBuilder.create((String)"newOpt");
        Options opts = new Options();
        opts.addOption(opt);
        String[] args = new String[]{"--newOpt", "7"};
        GenericOptionsParser g = new GenericOptionsParser(opts, args);
        Assert.assertEquals((String)"New option was ignored", (Object)"7", (Object)g.getCommandLine().getOptionValues("newOpt")[0]);
    }

    @Test
    public void testConfWithMultipleOpts() throws Exception {
        String[] args = new String[]{"--conf=foo", "--conf=bar"};
        GenericOptionsParser g = new GenericOptionsParser(args);
        Assert.assertEquals((String)"1st conf param is incorrect", (Object)"foo", (Object)g.getCommandLine().getOptionValues("conf")[0]);
        Assert.assertEquals((String)"2st conf param is incorrect", (Object)"bar", (Object)g.getCommandLine().getOptionValues("conf")[1]);
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.localFs = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = GenericTestUtils.getTestDir("generic");
        if (this.testDir.exists()) {
            this.localFs.delete(new Path(this.testDir.toString()), true);
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.testDir.exists()) {
            this.localFs.delete(new Path(this.testDir.toString()), true);
        }
    }

    @Test
    public void testTokenCacheOption() throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
        File tmpFile = new File(this.testDir, "tokenCacheFile");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        String[] args = new String[]{"-tokenCacheFile", tmpFile.toURI().toString()};
        Exception th = null;
        try {
            new GenericOptionsParser(this.conf, args);
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertNotNull((Object)th);
        Assert.assertTrue((String)"FileNotFoundException is not thrown", (boolean)(th instanceof FileNotFoundException));
        Path tmpPath = localFs.makeQualified(new Path(tmpFile.toString()));
        Token token = new Token("identifier".getBytes(), "password".getBytes(), new Text("token-kind"), new Text("token-service"));
        Credentials creds = new Credentials();
        creds.addToken(new Text("token-alias"), token);
        creds.writeTokenStorageFile(tmpPath, this.conf);
        new GenericOptionsParser(this.conf, args);
        String fileName = this.conf.get("mapreduce.job.credentials.binary");
        Assert.assertNotNull((String)"files is null", (Object)fileName);
        Assert.assertEquals((String)"files option does not match", (Object)tmpPath.toString(), (Object)fileName);
        Credentials ugiCreds = UserGroupInformation.getCurrentUser().getCredentials();
        Assert.assertEquals((long)1L, (long)ugiCreds.numberOfTokens());
        Token ugiToken = ugiCreds.getToken(new Text("token-alias"));
        Assert.assertNotNull((Object)ugiToken);
        Assert.assertEquals((Object)token, (Object)ugiToken);
        localFs.delete(new Path(this.testDir.getAbsolutePath()), true);
    }

    @Test
    public void testDOptionParsing() throws Exception {
        String[] args = new String[]{};
        String[] expectedRemainingArgs = new String[]{};
        HashMap expectedMap = Maps.newHashMap();
        this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
        args = new String[]{"-Dkey1=value1"};
        expectedRemainingArgs = new String[]{};
        expectedMap = Maps.newHashMap();
        expectedMap.put("key1", "value1");
        this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
        args = new String[]{"-fs", "hdfs://somefs/", "-Dkey1=value1", "arg1"};
        expectedRemainingArgs = new String[]{"arg1"};
        this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
        args = new String[]{"-fs", "hdfs://somefs/", "-D", "key1=value1", "arg1"};
        this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
        if (Shell.WINDOWS) {
            args = new String[]{"-fs", "hdfs://somefs/", "-D", "key1", "value1", "arg1"};
            this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
            args = new String[]{"-fs", "hdfs://somefs/", "-Dkey1", "value1", "arg1"};
            this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
            args = new String[]{"-fs", "hdfs://somefs/", "-D", "key1", "value1", "-fs", "someother", "-D", "key2", "value2", "arg1", "arg2"};
            expectedRemainingArgs = new String[]{"arg1", "arg2"};
            expectedMap = Maps.newHashMap();
            expectedMap.put("key1", "value1");
            expectedMap.put("key2", "value2");
            this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
            args = new String[]{"-fs", "hdfs://somefs/", "-D", "key1", "value1", "-fs", "someother", "-D", "key2", "value2"};
            expectedRemainingArgs = new String[]{};
            this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
            args = new String[]{"-fs", "hdfs://somefs/", "-D", "key1", "value1", "-fs", "someother", "-D", "key2"};
            expectedMap = Maps.newHashMap();
            expectedMap.put("key1", "value1");
            expectedMap.put("key2", null);
            this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
        }
        args = new String[]{"-fs", "hdfs://somefs/", "-D", "key1=value1", "-fs", "someother", "-Dkey2"};
        expectedRemainingArgs = new String[]{};
        expectedMap = Maps.newHashMap();
        expectedMap.put("key1", "value1");
        expectedMap.put("key2", null);
        this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
        args = new String[]{"-fs", "hdfs://somefs/", "-D"};
        expectedMap = Maps.newHashMap();
        this.assertDOptionParsing(args, expectedMap, expectedRemainingArgs);
    }

    private void assertDOptionParsing(String[] args, Map<String, String> expectedMap, String[] expectedRemainingArgs) throws Exception {
        for (Map.Entry<String, String> entry : expectedMap.entrySet()) {
            Assert.assertNull((Object)this.conf.get(entry.getKey()));
        }
        Configuration conf = new Configuration();
        GenericOptionsParser parser = new GenericOptionsParser(conf, args);
        Object[] remainingArgs = parser.getRemainingArgs();
        for (Map.Entry<String, String> entry : expectedMap.entrySet()) {
            Assert.assertEquals((Object)entry.getValue(), (Object)conf.get(entry.getKey()));
        }
        Assert.assertArrayEquals((String)(Arrays.toString(remainingArgs) + Arrays.toString(expectedRemainingArgs)), (Object[])expectedRemainingArgs, (Object[])remainingArgs);
    }

    @Test
    public void testNullArgs() throws IOException {
        GenericOptionsParser parser = new GenericOptionsParser(this.conf, null);
        parser.getRemainingArgs();
    }
}

