/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class OfflineCallback
implements AsyncCallback.StringCallback {
    private static final Log LOG = LogFactory.getLog(OfflineCallback.class);
    private final ExistCallback callBack;
    private final ZooKeeperWatcher zkw;
    private final ServerName destination;
    private final AtomicInteger counter;

    OfflineCallback(ZooKeeperWatcher zkw, ServerName destination, AtomicInteger counter, Map<String, Integer> offlineNodesVersions) {
        this.callBack = new ExistCallback(destination, counter, offlineNodesVersions);
        this.destination = destination;
        this.counter = counter;
        this.zkw = zkw;
    }

    public void processResult(int rc, String path, Object ctx, String name) {
        if (rc == KeeperException.Code.NODEEXISTS.intValue()) {
            LOG.warn((Object)("Node for " + path + " already exists"));
        } else if (rc != 0) {
            LOG.warn((Object)("rc != 0 for " + path + " -- retryable connectionloss -- " + "FIX see http://wiki.apache.org/hadoop/ZooKeeper/FAQ#A2"));
            this.counter.addAndGet(1);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rs=" + ctx + ", server=" + this.destination));
        }
        ZooKeeper zk = this.zkw.getRecoverableZooKeeper().getZooKeeper();
        zk.exists(path, (Watcher)this.zkw, (AsyncCallback.StatCallback)this.callBack, ctx);
    }

    static class ExistCallback
    implements AsyncCallback.StatCallback {
        private static final Log LOG = LogFactory.getLog(ExistCallback.class);
        private final Map<String, Integer> offlineNodesVersions;
        private final AtomicInteger counter;
        private ServerName destination;

        ExistCallback(ServerName destination, AtomicInteger counter, Map<String, Integer> offlineNodesVersions) {
            this.offlineNodesVersions = offlineNodesVersions;
            this.destination = destination;
            this.counter = counter;
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc != 0) {
                LOG.warn((Object)("rc != 0 for " + path + " -- retryable connectionloss -- " + "FIX see http://wiki.apache.org/hadoop/ZooKeeper/FAQ#A2"));
                this.counter.addAndGet(1);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("rs=" + ctx + ", server=" + this.destination));
            }
            HRegionInfo region = ((RegionState)ctx).getRegion();
            this.offlineNodesVersions.put(region.getEncodedName(), stat.getVersion());
            this.counter.addAndGet(1);
        }
    }
}

