/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class RowCounter
extends Configured
implements Tool {
    static final String NAME = "rowcounter";

    public JobConf createSubmittableJob(String[] args) throws IOException {
        JobConf c = new JobConf(this.getConf(), ((Object)((Object)this)).getClass());
        c.setJobName(NAME);
        StringBuilder sb = new StringBuilder();
        int columnoffset = 2;
        for (int i = 2; i < args.length; ++i) {
            if (i > 2) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        TableMapReduceUtil.initTableMapJob(args[1], sb.toString(), RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, c);
        c.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((JobConf)c, (Path)new Path(args[0]));
        return c;
    }

    static int printUsage() {
        System.out.println("rowcounter <outputdir> <tablename> <column1> [<column2>...]");
        return -1;
    }

    public int run(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("ERROR: Wrong number of parameters: " + args.length);
            return RowCounter.printUsage();
        }
        JobClient.runJob((JobConf)this.createSubmittableJob(args));
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int errCode = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new RowCounter(), (String[])args);
        System.exit(errCode);
    }

    static class RowCounterMapper
    implements TableMap<ImmutableBytesWritable, Result> {
        RowCounterMapper() {
        }

        public void map(ImmutableBytesWritable row, Result values, OutputCollector<ImmutableBytesWritable, Result> output, Reporter reporter) throws IOException {
            reporter.incrCounter((Enum)Counters.ROWS, 1L);
        }

        public void configure(JobConf jc) {
        }

        public void close() throws IOException {
        }

        private static enum Counters {
            ROWS;

        }
    }
}

