/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;

@InterfaceAudience.Private
public class ClusterStatusChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(ClusterStatusChore.class);
    private final HMaster master;
    private final LoadBalancer balancer;

    public ClusterStatusChore(HMaster master, LoadBalancer balancer) {
        super(master.getServerName() + "-ClusterStatusChore", (Stoppable)master, master.getConfiguration().getInt("hbase.balancer.statusPeriod", 60000));
        this.master = master;
        this.balancer = balancer;
    }

    protected void chore() {
        try {
            this.balancer.setClusterStatus(this.master.getClusterStatus());
        }
        catch (InterruptedIOException e) {
            LOG.warn((Object)"Ignoring interruption", (Throwable)e);
        }
    }
}

