/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.jruby.JRubyLibrary;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.DataType;

public abstract class AbstractRubyMethod
extends RubyObject
implements DataType {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected DynamicMethod method;

    protected AbstractRubyMethod(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public DynamicMethod getMethod() {
        return this.method;
    }

    @JRubyMethod(name={"arity"})
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    @JRubyMethod(name={"eql?"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_eql19(ThreadContext context, IRubyObject other) {
        return this.op_equal(context, other);
    }

    @Override
    public abstract AbstractRubyMethod rbClone();

    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject name(ThreadContext context) {
        return context.runtime.newString(this.methodName);
    }

    @JRubyMethod(name={"name"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject name19(ThreadContext context) {
        return context.runtime.newSymbol(this.methodName);
    }

    public String getMethodName() {
        return this.methodName;
    }

    @JRubyMethod(name={"owner"})
    public IRubyObject owner(ThreadContext context) {
        return this.implementationModule;
    }

    @JRubyMethod(name={"source_location"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject source_location(ThreadContext context) {
        Ruby runtime = context.runtime;
        String filename2 = this.getFilename();
        if (filename2 != null) {
            return runtime.newArray((IRubyObject)runtime.newString(filename2), (IRubyObject)runtime.newFixnum(this.getLine()));
        }
        return context.runtime.getNil();
    }

    public String getFilename() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getFile();
        }
        return null;
    }

    public int getLine() {
        DynamicMethod realMethod = this.method.getRealMethod();
        if (realMethod instanceof PositionAware) {
            PositionAware poser = (PositionAware)((Object)realMethod);
            return poser.getLine() + 1;
        }
        return -1;
    }

    @JRubyMethod(name={"parameters"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject parameters(ThreadContext context) {
        return JRubyLibrary.MethodExtensions.methodArgs(this);
    }
}

