/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobQueueClient;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRClientClusterFactory;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestNetworkedJob {
    private static String TEST_ROOT_DIR = new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+');
    private static Path testDir = new Path(TEST_ROOT_DIR + "/test_mini_mr_local");
    private static Path inFile = new Path(testDir, "in");
    private static Path outDir = new Path(testDir, "out");

    @Test(timeout=5000L)
    public void testGetNullCounters() throws Exception {
        Job mockJob = (Job)Mockito.mock(Job.class);
        JobClient.NetworkedJob underTest = new JobClient.NetworkedJob(mockJob);
        Mockito.when((Object)mockJob.getCounters()).thenReturn(null);
        Assert.assertNull((Object)underTest.getCounters());
        ((Job)Mockito.verify((Object)mockJob)).getCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=500000L)
    public void testGetJobStatus() throws IOException, InterruptedException, ClassNotFoundException {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        try {
            mr = this.createMiniClusterWithCapacityScheduler();
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            RunningJob rj = client.submitJob(job);
            JobID jobId = rj.getID();
            Assert.assertEquals((String)"Expected matching JobIDs", (Object)jobId, (Object)client.getJob(jobId).getJobStatus().getJobID());
            Assert.assertEquals((String)"Expected matching startTimes", (long)rj.getJobStatus().getStartTime(), (long)client.getJob(jobId).getJobStatus().getStartTime());
        }
        finally {
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=500000L)
    public void testNetworkedJob() throws Exception {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        try {
            mr = this.createMiniClusterWithCapacityScheduler();
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            RunningJob rj = client.submitJob(job);
            JobID jobId = rj.getID();
            JobClient.NetworkedJob runningJob = (JobClient.NetworkedJob)client.getJob(jobId);
            runningJob.setJobPriority(JobPriority.HIGH.name());
            Assert.assertTrue((boolean)runningJob.getConfiguration().toString().endsWith("0001/job.xml"));
            Assert.assertEquals((Object)jobId, (Object)runningJob.getID());
            Assert.assertEquals((Object)jobId.toString(), (Object)runningJob.getJobID());
            Assert.assertEquals((Object)"N/A", (Object)runningJob.getJobName());
            Assert.assertTrue((boolean)runningJob.getJobFile().endsWith(".staging/" + runningJob.getJobID() + "/job.xml"));
            Assert.assertTrue((runningJob.getTrackingURL().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((runningJob.mapProgress() == 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((runningJob.reduceProgress() == 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((runningJob.cleanupProgress() == 0.0f ? 1 : 0) != 0);
            Assert.assertTrue((runningJob.setupProgress() == 0.0f ? 1 : 0) != 0);
            TaskCompletionEvent[] tce = runningJob.getTaskCompletionEvents(0);
            Assert.assertEquals((long)tce.length, (long)0L);
            Assert.assertEquals((Object)"", (Object)runningJob.getHistoryUrl());
            Assert.assertFalse((boolean)runningJob.isRetired());
            Assert.assertEquals((Object)"", (Object)runningJob.getFailureInfo());
            Assert.assertEquals((Object)"N/A", (Object)runningJob.getJobStatus().getJobName());
            Assert.assertEquals((long)0L, (long)client.getMapTaskReports(jobId).length);
            try {
                client.getSetupTaskReports(jobId);
            }
            catch (YarnRuntimeException e) {
                Assert.assertEquals((Object)"Unrecognized task type: JOB_SETUP", (Object)e.getMessage());
            }
            try {
                client.getCleanupTaskReports(jobId);
            }
            catch (YarnRuntimeException e) {
                Assert.assertEquals((Object)"Unrecognized task type: JOB_CLEANUP", (Object)e.getMessage());
            }
            Assert.assertEquals((long)0L, (long)client.getReduceTaskReports(jobId).length);
            ClusterStatus status = client.getClusterStatus(true);
            Assert.assertEquals((long)2L, (long)status.getActiveTrackerNames().size());
            Assert.assertEquals((long)0L, (long)status.getBlacklistedTrackers());
            Assert.assertEquals((long)0L, (long)status.getBlacklistedTrackerNames().size());
            Assert.assertEquals((long)0L, (long)status.getBlackListedTrackersInfo().size());
            Assert.assertEquals((Object)Cluster.JobTrackerStatus.RUNNING, (Object)status.getJobTrackerStatus());
            Assert.assertEquals((long)1L, (long)status.getMapTasks());
            Assert.assertEquals((long)20L, (long)status.getMaxMapTasks());
            Assert.assertEquals((long)4L, (long)status.getMaxReduceTasks());
            Assert.assertEquals((long)0L, (long)status.getNumExcludedNodes());
            Assert.assertEquals((long)1L, (long)status.getReduceTasks());
            Assert.assertEquals((long)2L, (long)status.getTaskTrackers());
            Assert.assertEquals((long)0L, (long)status.getTTExpiryInterval());
            Assert.assertEquals((Object)Cluster.JobTrackerStatus.RUNNING, (Object)status.getJobTrackerStatus());
            Assert.assertEquals((long)0L, (long)status.getGraylistedTrackers());
            ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
            status.write((DataOutput)new DataOutputStream(dataOut));
            ClusterStatus status2 = new ClusterStatus();
            status2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(dataOut.toByteArray())));
            Assert.assertEquals((Object)status.getActiveTrackerNames(), (Object)status2.getActiveTrackerNames());
            Assert.assertEquals((Object)status.getBlackListedTrackersInfo(), (Object)status2.getBlackListedTrackersInfo());
            Assert.assertEquals((long)status.getMapTasks(), (long)status2.getMapTasks());
            JobClient.setTaskOutputFilter((JobConf)job, (JobClient.TaskStatusFilter)JobClient.TaskStatusFilter.ALL);
            Assert.assertEquals((Object)JobClient.TaskStatusFilter.ALL, (Object)JobClient.getTaskOutputFilter((JobConf)job));
            Assert.assertEquals((long)20L, (long)client.getDefaultMaps());
            Assert.assertEquals((long)4L, (long)client.getDefaultReduces());
            Assert.assertEquals((Object)"jobSubmitDir", (Object)client.getSystemDir().getName());
            JobQueueInfo[] rootQueueInfo = client.getRootQueues();
            Assert.assertEquals((long)1L, (long)rootQueueInfo.length);
            Assert.assertEquals((Object)"default", (Object)rootQueueInfo[0].getQueueName());
            JobQueueInfo[] qinfo = client.getQueues();
            Assert.assertEquals((long)1L, (long)qinfo.length);
            Assert.assertEquals((Object)"default", (Object)qinfo[0].getQueueName());
            Assert.assertEquals((long)0L, (long)client.getChildQueues("default").length);
            Assert.assertEquals((long)1L, (long)client.getJobsFromQueue("default").length);
            Assert.assertTrue((boolean)client.getJobsFromQueue("default")[0].getJobFile().endsWith("/job.xml"));
            JobQueueInfo qi = client.getQueueInfo("default");
            Assert.assertEquals((Object)"default", (Object)qi.getQueueName());
            Assert.assertEquals((Object)"running", (Object)qi.getQueueState());
            QueueAclsInfo[] aai = client.getQueueAclsForCurrentUser();
            Assert.assertEquals((long)2L, (long)aai.length);
            Assert.assertEquals((Object)"root", (Object)aai[0].getQueueName());
            Assert.assertEquals((Object)"default", (Object)aai[1].getQueueName());
            Assert.assertEquals((String)"Expected matching JobIDs", (Object)jobId, (Object)client.getJob(jobId).getJobStatus().getJobID());
            Assert.assertEquals((String)"Expected matching startTimes", (long)rj.getJobStatus().getStartTime(), (long)client.getJob(jobId).getJobStatus().getStartTime());
        }
        finally {
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }

    @Test(timeout=5000L)
    public void testBlackListInfo() throws IOException {
        ClusterStatus.BlackListInfo info = new ClusterStatus.BlackListInfo();
        info.setBlackListReport("blackListInfo");
        info.setReasonForBlackListing("reasonForBlackListing");
        info.setTrackerName("trackerName");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        info.write((DataOutput)out);
        ClusterStatus.BlackListInfo info2 = new ClusterStatus.BlackListInfo();
        info2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(byteOut.toByteArray())));
        Assert.assertEquals((Object)info, (Object)info2);
        Assert.assertEquals((Object)info.toString(), (Object)info2.toString());
        Assert.assertEquals((Object)"trackerName", (Object)info2.getTrackerName());
        Assert.assertEquals((Object)"reasonForBlackListing", (Object)info2.getReasonForBlackListing());
        Assert.assertEquals((Object)"blackListInfo", (Object)info2.getBlackListReport());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=500000L)
    public void testJobQueueClient() throws Exception {
        MiniMRClientCluster mr = null;
        FileSystem fileSys = null;
        PrintStream oldOut = System.out;
        try {
            mr = this.createMiniClusterWithCapacityScheduler();
            JobConf job = new JobConf(mr.getConfig());
            fileSys = FileSystem.get((Configuration)job);
            fileSys.delete(testDir, true);
            FSDataOutputStream out = fileSys.create(inFile, true);
            out.writeBytes("This is a test file");
            out.close();
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{inFile});
            FileOutputFormat.setOutputPath((JobConf)job, (Path)outDir);
            job.setInputFormat(TextInputFormat.class);
            job.setOutputFormat(TextOutputFormat.class);
            job.setMapperClass(IdentityMapper.class);
            job.setReducerClass(IdentityReducer.class);
            job.setNumReduceTasks(0);
            JobClient client = new JobClient(mr.getConfig());
            client.submitJob(job);
            JobQueueClient jobClient = new JobQueueClient(job);
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg = new String[]{"-list"};
            jobClient.run(arg);
            Assert.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            Assert.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg1 = new String[]{"-showacls"};
            jobClient.run(arg1);
            Assert.assertTrue((boolean)bytes.toString().contains("Queue acls for user :"));
            Assert.assertTrue((boolean)bytes.toString().contains("root  ADMINISTER_QUEUE,SUBMIT_APPLICATIONS"));
            Assert.assertTrue((boolean)bytes.toString().contains("default  ADMINISTER_QUEUE,SUBMIT_APPLICATIONS"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg2 = new String[]{"-info", "default"};
            jobClient.run(arg2);
            Assert.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            Assert.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            Assert.assertTrue((boolean)bytes.toString().contains("Scheduling Info"));
            bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            String[] arg3 = new String[]{"-info", "default", "-showJobs"};
            jobClient.run(arg3);
            Assert.assertTrue((boolean)bytes.toString().contains("Queue Name : default"));
            Assert.assertTrue((boolean)bytes.toString().contains("Queue State : running"));
            Assert.assertTrue((boolean)bytes.toString().contains("Scheduling Info"));
            Assert.assertTrue((boolean)bytes.toString().contains("job_1"));
            String[] arg4 = new String[]{};
            jobClient.run(arg4);
        }
        finally {
            System.setOut(oldOut);
            if (fileSys != null) {
                fileSys.delete(testDir, true);
            }
            if (mr != null) {
                mr.stop();
            }
        }
    }

    private MiniMRClientCluster createMiniClusterWithCapacityScheduler() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, CapacityScheduler.class);
        return MiniMRClientClusterFactory.create(this.getClass(), 2, conf);
    }
}

