/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.util;

import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.mapreduce.lib.util.ConfiguratorBase;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.hadoop.conf.Configuration;

public class FileOutputConfigurator
extends ConfiguratorBase {
    protected static Boolean isSupportedAccumuloProperty(Property property) {
        switch (property) {
            case TABLE_FILE_COMPRESSION_TYPE: 
            case TABLE_FILE_COMPRESSED_BLOCK_SIZE: 
            case TABLE_FILE_BLOCK_SIZE: 
            case TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX: 
            case TABLE_FILE_REPLICATION: {
                return true;
            }
        }
        return false;
    }

    private static <T> void setAccumuloProperty(Class<?> implementingClass, Configuration conf, Property property, T value) {
        String val;
        if (FileOutputConfigurator.isSupportedAccumuloProperty(property).booleanValue()) {
            val = String.valueOf(value);
            if (!property.getType().isValidFormat(val)) {
                throw new IllegalArgumentException("Value is not appropriate for property type '" + (Object)((Object)property.getType()) + "'");
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration property " + property.getKey());
        }
        conf.set(FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + "." + property.getKey(), val);
    }

    public static AccumuloConfiguration getAccumuloConfiguration(Class<?> implementingClass, Configuration conf) {
        String prefix = FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + ".";
        ConfigurationCopy acuConf = new ConfigurationCopy(AccumuloConfiguration.getDefaultConfiguration());
        for (Map.Entry entry : conf) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            acuConf.set(Property.getPropertyByKey(((String)entry.getKey()).substring(prefix.length())), (String)entry.getValue());
        }
        return acuConf;
    }

    public static void setCompressionType(Class<?> implementingClass, Configuration conf, String compressionType) {
        if (compressionType == null || !Arrays.asList("none", "gz", "lzo", "snappy").contains(compressionType)) {
            throw new IllegalArgumentException("Compression type must be one of: none, gz, lzo, snappy");
        }
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSION_TYPE, compressionType);
    }

    public static void setDataBlockSize(Class<?> implementingClass, Configuration conf, long dataBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE, dataBlockSize);
    }

    public static void setFileBlockSize(Class<?> implementingClass, Configuration conf, long fileBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_BLOCK_SIZE, fileBlockSize);
    }

    public static void setIndexBlockSize(Class<?> implementingClass, Configuration conf, long indexBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX, indexBlockSize);
    }

    public static void setReplication(Class<?> implementingClass, Configuration conf, int replication) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_REPLICATION, replication);
    }

    public static enum Opts {
        ACCUMULO_PROPERTIES;

    }
}

