/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.system;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;

public class DeletingIterator
extends WrappingIterator {
    private boolean propogateDeletes;
    private Key workKey = new Key();

    public DeletingIterator deepCopy(IteratorEnvironment env) {
        return new DeletingIterator(this, env);
    }

    public DeletingIterator(DeletingIterator other, IteratorEnvironment env) {
        this.setSource(other.getSource().deepCopy(env));
        this.propogateDeletes = other.propogateDeletes;
    }

    public DeletingIterator() {
    }

    public DeletingIterator(SortedKeyValueIterator<Key, Value> iterator, boolean propogateDeletes) throws IOException {
        this.setSource(iterator);
        this.propogateDeletes = propogateDeletes;
    }

    @Override
    public void next() throws IOException {
        if (super.getTopKey().isDeleted()) {
            this.skipRowColumn();
        } else {
            this.getSource().next();
        }
        this.findTop();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Range seekRange = IteratorUtil.maximizeStartKeyTimeStamp(range);
        super.seek(seekRange, columnFamilies, inclusive);
        this.findTop();
        if (range.getStartKey() != null) {
            while (this.getSource().hasTop() && this.getSource().getTopKey().compareTo(range.getStartKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME) < 0) {
                this.next();
            }
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }
    }

    private void findTop() throws IOException {
        if (!this.propogateDeletes) {
            while (this.getSource().hasTop() && this.getSource().getTopKey().isDeleted()) {
                this.skipRowColumn();
            }
        }
    }

    private void skipRowColumn() throws IOException {
        this.workKey.set(this.getSource().getTopKey());
        Key keyToSkip = this.workKey;
        this.getSource().next();
        while (this.getSource().hasTop() && this.getSource().getTopKey().equals(keyToSkip, PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            this.getSource().next();
        }
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }
}

