/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class GrepIterator
extends Filter {
    private byte[] term;

    @Override
    public boolean accept(Key k, Value v) {
        return this.match(v.get()) || this.match(k.getRowData()) || this.match(k.getColumnFamilyData()) || this.match(k.getColumnQualifierData());
    }

    private boolean match(ByteSequence bs) {
        return GrepIterator.indexOf(bs.getBackingArray(), bs.offset(), bs.length(), this.term) >= 0;
    }

    private boolean match(byte[] ba) {
        return GrepIterator.indexOf(ba, 0, ba.length, this.term) >= 0;
    }

    private static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target) {
        byte first = target[0];
        int targetCount = target.length;
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        GrepIterator copy = (GrepIterator)super.deepCopy(env);
        copy.term = Arrays.copyOf(this.term, this.term.length);
        return copy;
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.term = options.get("term").getBytes();
    }

    public static void setTerm(IteratorSetting cfg, String term) {
        cfg.addOption("term", term);
    }
}

