/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.tabletserver.log;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;

public class LogEntry {
    public KeyExtent extent;
    public long timestamp;
    public String server;
    public String filename;
    public int tabletId;
    public Collection<String> logSet;

    public String toString() {
        return this.extent.toString() + " " + this.filename + " (" + this.tabletId + ")";
    }

    public String getName() {
        return this.server + "/" + this.filename;
    }

    public byte[] toBytes() throws IOException {
        DataOutputBuffer out = new DataOutputBuffer();
        this.extent.write((DataOutput)out);
        out.writeLong(this.timestamp);
        out.writeUTF(this.server);
        out.writeUTF(this.filename);
        out.write(this.tabletId);
        out.write(this.logSet.size());
        for (String s : this.logSet) {
            out.writeUTF(s);
        }
        return Arrays.copyOf(out.getData(), out.getLength());
    }

    public void fromBytes(byte[] bytes) throws IOException {
        DataInputBuffer inp = new DataInputBuffer();
        inp.reset(bytes, bytes.length);
        this.extent = new KeyExtent();
        this.extent.readFields((DataInput)inp);
        this.timestamp = inp.readLong();
        this.server = inp.readUTF();
        this.filename = inp.readUTF();
        this.tabletId = inp.read();
        int count = inp.read();
        ArrayList<String> logSet = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            logSet.add(inp.readUTF());
        }
        this.logSet = logSet;
    }
}

