/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.trace.ZooTraceClient;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.accumulo.trace.instrument.receivers.SpanReceiver;
import org.apache.zookeeper.KeeperException;

public class DistributedTrace {
    public static void enable(Instance instance, ZooReader zoo, String application, String address) throws IOException, KeeperException, InterruptedException {
        String path = ZooUtil.getRoot(instance) + "/tracers";
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress().toString();
            }
            catch (UnknownHostException e) {
                address = "unknown";
            }
        }
        Tracer.getInstance().addReceiver((SpanReceiver)new ZooTraceClient(zoo, path, address, application, 1000L));
    }
}

