/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.trace;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.trace.thrift.RemoteSpan;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public class TraceFormatter
implements Formatter {
    public static final String DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(TraceFormatter.DATE_FORMAT);
        }
    };
    private static final Text SPAN_CF = new Text("span");
    private Iterator<Map.Entry<Key, Value>> scanner;
    private boolean printTimeStamps;

    public static String formatDate(Date date) {
        return formatter.get().format(date);
    }

    public static RemoteSpan getRemoteSpan(Map.Entry<Key, Value> entry) {
        TMemoryInputTransport transport = new TMemoryInputTransport(entry.getValue().get());
        TCompactProtocol protocol = new TCompactProtocol((TTransport)transport);
        RemoteSpan span = new RemoteSpan();
        try {
            span.read((TProtocol)protocol);
        }
        catch (TException ex) {
            throw new RuntimeException(ex);
        }
        return span;
    }

    @Override
    public boolean hasNext() {
        return this.scanner.hasNext();
    }

    @Override
    public String next() {
        Map.Entry<Key, Value> next = this.scanner.next();
        if (next.getKey().getColumnFamily().equals((Object)SPAN_CF)) {
            StringBuilder result = new StringBuilder();
            SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT);
            RemoteSpan span = TraceFormatter.getRemoteSpan(next);
            result.append("----------------------\n");
            result.append(String.format(" %12s:%s%n", "name", span.description));
            result.append(String.format(" %12s:%s%n", "trace", Long.toHexString(span.traceId)));
            result.append(String.format(" %12s:%s%n", "loc", span.svc + "@" + span.sender));
            result.append(String.format(" %12s:%s%n", "span", Long.toHexString(span.spanId)));
            result.append(String.format(" %12s:%s%n", "parent", Long.toHexString(span.parentId)));
            result.append(String.format(" %12s:%s%n", "start", dateFormatter.format(span.start)));
            result.append(String.format(" %12s:%s%n", "ms", span.stop - span.start));
            for (Map.Entry entry : span.data.entrySet()) {
                result.append(String.format(" %12s:%s%n", entry.getKey(), entry.getValue()));
            }
            if (this.printTimeStamps) {
                result.append(String.format(" %-12s:%d%n", "timestamp", next.getKey().getTimestamp()));
            }
            return result.toString();
        }
        return DefaultFormatter.formatEntry(next, this.printTimeStamps);
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    @Override
    public void initialize(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps) {
        this.scanner = scanner.iterator();
        this.printTimeStamps = printTimestamps;
    }
}

