/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;

public class ShardedTableDistributionFormatter
extends DefaultFormatter {
    private Map<String, HashSet<String>> countsByDay = new HashMap<String, HashSet<String>>();

    @Override
    public String next() {
        Iterator<Map.Entry<Key, Value>> si = super.getScannerIterator();
        ShardedTableDistributionFormatter.checkState(si, true);
        while (si.hasNext()) {
            this.aggregateStats(si.next());
        }
        return this.getStats();
    }

    private void aggregateStats(Map.Entry<Key, Value> entry) {
        if (entry.getKey().getColumnFamily().toString().equals("~tab") && entry.getKey().getColumnQualifier().toString().equals("loc")) {
            String row = entry.getKey().getRow().toString();
            int semicolon = row.indexOf(";");
            String day = null;
            day = semicolon != -1 ? row.substring(++semicolon, semicolon + 8) : "NULL    ";
            String server = entry.getValue().toString();
            if (this.countsByDay.get(day) == null) {
                this.countsByDay.put(day, new HashSet());
            }
            this.countsByDay.get(day).add(server);
        }
    }

    private String getStats() {
        StringBuilder buf = new StringBuilder();
        buf.append("DAY   \t\tSERVERS\n");
        buf.append("------\t\t-------\n");
        for (String day : this.countsByDay.keySet()) {
            buf.append(day + "\t\t" + this.countsByDay.get(day).size() + "\n");
        }
        return buf.toString();
    }
}

