/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class HistoryCommand
extends Shell.Command {
    private Option clearHist;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String home = System.getProperty("HOME");
        if (home == null) {
            home = System.getenv("HOME");
        }
        String histDir = home + "/.accumulo";
        int counter = 0;
        if (cl.hasOption(this.clearHist.getOpt())) {
            try {
                FileWriter outFile = new FileWriter(histDir + "/shell_history.txt");
                PrintWriter out = new PrintWriter(outFile);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                BufferedReader in = new BufferedReader(new FileReader(histDir + "/shell_history.txt"));
                try {
                    String Line = in.readLine();
                    while (Line != null) {
                        shellState.getReader().printString(counter + " " + Line + "\n");
                        ++counter;
                        Line = in.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public String description() {
        return "generates a list of commands previously executed";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.clearHist = new Option("c", "clear", false, "clear history file");
        this.clearHist.setRequired(false);
        o.addOption(this.clearHist);
        return o;
    }
}

