/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public abstract class ShellPluginConfigurationCommand
extends Shell.Command {
    private Option removePluginOption;
    private Option pluginClassOption;
    private Option listPluginOption;
    private String pluginType;
    private Property tableProp;
    private String classOpt;

    ShellPluginConfigurationCommand(String typeName, Property tableProp, String classOpt) {
        this.pluginType = typeName;
        this.tableProp = tableProp;
        this.classOpt = classOpt;
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        if (cl.hasOption(this.removePluginOption.getOpt())) {
            this.removePlugin(cl, shellState, tableName);
            shellState.getReader().printString("Removed " + this.pluginType + " on " + tableName + "\n");
        } else if (cl.hasOption(this.listPluginOption.getOpt())) {
            for (Map.Entry<String, String> ent : shellState.getConnector().tableOperations().getProperties(tableName)) {
                if (!ent.getKey().startsWith(this.tableProp.toString())) continue;
                shellState.getReader().printString(ent.getKey() + ": " + ent.getValue() + "\n");
            }
        } else {
            String className = cl.getOptionValue(this.pluginClassOption.getOpt());
            this.setPlugin(cl, shellState, tableName, className);
        }
        return 0;
    }

    protected void setPlugin(CommandLine cl, Shell shellState, String tableName, String className) throws AccumuloException, AccumuloSecurityException {
        shellState.getConnector().tableOperations().setProperty(tableName, this.tableProp.toString(), className);
    }

    protected void removePlugin(CommandLine cl, Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException {
        shellState.getConnector().tableOperations().removeProperty(tableName, this.tableProp.toString());
    }

    public static <T> Class<? extends T> getPluginClass(String tableName, Shell shellState, Class<T> clazz, Property pluginProp) {
        Iterator<Map.Entry<String, String>> props;
        try {
            props = shellState.getConnector().tableOperations().getProperties(tableName).iterator();
        }
        catch (AccumuloException e) {
            return null;
        }
        catch (TableNotFoundException e) {
            return null;
        }
        while (props.hasNext()) {
            Class pluginClazz;
            Map.Entry<String, String> ent = props.next();
            if (!ent.getKey().equals(pluginProp.toString())) continue;
            try {
                pluginClazz = AccumuloVFSClassLoader.loadClass((String)ent.getValue(), clazz);
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger(ShellPluginConfigurationCommand.class).warn((Object)("Class not found" + e.getMessage()));
                return null;
            }
            return pluginClazz;
        }
        return null;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup actionGroup = new OptionGroup();
        this.pluginClassOption = new Option(this.classOpt, this.pluginType, true, "fully qualified name of the " + this.pluginType + " class to use");
        this.pluginClassOption.setArgName("className");
        this.removePluginOption = new Option("r", "remove", false, "remove the current " + this.pluginType + "");
        this.listPluginOption = new Option("l", "list", false, "display the current " + this.pluginType + "");
        actionGroup.addOption(this.pluginClassOption);
        actionGroup.addOption(this.removePluginOption);
        actionGroup.addOption(this.listPluginOption);
        actionGroup.setRequired(true);
        o.addOptionGroup(actionGroup);
        o.addOption(OptUtil.tableOpt("table to set the " + this.pluginType + " on"));
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

