/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument.receivers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.accumulo.trace.instrument.receivers.SpanReceiver;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogSpans
implements SpanReceiver {
    private static final Logger log = Logger.getLogger(LogSpans.class);
    private static final DateFormat fmt = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final Level SPAN = new SpanLevel();

    public static String format(long traceId, long spanId, long parentId, long start, long stop, String description, Map<String, String> data) {
        String parentStr = "";
        if (parentId > 0L) {
            parentStr = " parent:" + parentId;
        }
        String startStr = fmt.format(new Date(start));
        return String.format("%20s:%x id:%d%s start:%s ms:%d", description, traceId, spanId, parentStr, startStr, stop - start);
    }

    @Override
    public void span(long traceId, long spanId, long parentId, long start, long stop, String description, Map<String, String> data) {
        log.log((Priority)SPAN, (Object)LogSpans.format(traceId, spanId, parentId, start, stop, description, data));
    }

    @Override
    public void flush() {
    }

    public static class SpanLevel
    extends Level {
        private static final long serialVersionUID = 1L;

        protected SpanLevel() {
            super(10150, "SPAN", 10150);
        }

        public static Level toLevel(int val) {
            if (val == 10150) {
                return Level.DEBUG;
            }
            return Level.toLevel((int)val);
        }
    }
}

