/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.IndexedKey;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.PigNullableWritable;

public class MapReducePartitionerWrapper
extends org.apache.spark.Partitioner {
    private static final Log LOG = LogFactory.getLog(MapReducePartitionerWrapper.class);
    private int numPartitions;
    private String partitionerName;
    private transient Partitioner<PigNullableWritable, Writable> mapredPartitioner = null;
    private transient Method getPartitionMethod = null;

    public MapReducePartitionerWrapper(String partitionerName, int numPartitions) {
        if (partitionerName == null) {
            throw new RuntimeException("MapReduce Partitioner cannot be null.");
        }
        this.partitionerName = partitionerName;
        this.numPartitions = numPartitions;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPartition(final Object key) {
        try {
            PigNullableWritable writeableKey = new PigNullableWritable(){

                @Override
                public Object getValueAsPigType() {
                    if (key instanceof IndexedKey) {
                        IndexedKey indexedKey = (IndexedKey)key;
                        this.setIndex(indexedKey.getIndex());
                        return indexedKey.getKey();
                    }
                    return key;
                }
            };
            if (this.mapredPartitioner == null) {
                MapReducePartitionerWrapper mapReducePartitionerWrapper = this;
                synchronized (mapReducePartitionerWrapper) {
                    if (this.mapredPartitioner == null) {
                        Class mapredPartitionerClass = PigContext.resolveClassName(this.partitionerName);
                        Configuration conf = new Configuration();
                        this.mapredPartitioner = (Partitioner)ReflectionUtils.newInstance((Class)mapredPartitionerClass, (Configuration)conf);
                        this.getPartitionMethod = mapredPartitionerClass.getMethod("getPartition", PigNullableWritable.class, Writable.class, Integer.TYPE);
                    }
                }
            }
            int partition = (Integer)this.getPartitionMethod.invoke(this.mapredPartitioner, writeableKey, null, this.numPartitions);
            return partition;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

