/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;

public class PigParserNode
extends CommonTree {
    private String fileName = null;
    private int startLine = 0;
    private List<InvocationPoint> invokStack;

    public PigParserNode(Token t, String fileName, int lineOffset) {
        super(t);
        if (t != null && lineOffset > 0) {
            t.setLine(t.getLine() + lineOffset);
        }
        this.fileName = fileName;
    }

    public PigParserNode(Token t, String fileName, Token start) {
        this(t, fileName, 0);
        this.startLine = start.getLine();
    }

    public PigParserNode(PigParserNode node) {
        super(node);
        this.fileName = node.getFileName();
        this.invokStack = node.invokStack;
        this.startLine = node.startLine;
    }

    @Override
    public Tree dupNode() {
        return new PigParserNode(this);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setInvocationStack(List<InvocationPoint> stack) {
        this.invokStack = stack;
    }

    public List<InvocationPoint> getInvocationStack() {
        return this.invokStack;
    }

    public InvocationPoint getNextInvocationPoint() {
        if (this.invokStack == null || this.invokStack.isEmpty()) {
            return null;
        }
        return this.invokStack.remove(0);
    }

    public static class InvocationPoint {
        private int line;
        private String file;
        private String macro;

        public InvocationPoint(int line, String file, String macro) {
            this.line = line;
            this.file = file;
            this.macro = macro;
        }

        public int getLine() {
            return this.line;
        }

        public String getFile() {
            return this.file;
        }

        public String getMacro() {
            return this.macro;
        }
    }
}

