/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.io.Writable;

public class VectorMapOperator
extends MapOperator {
    private static final long serialVersionUID = 1L;

    @Override
    public void process(Writable value) throws HiveException {
        ExecMapperContext context = this.getExecContext();
        if (context != null && context.inputFileChanged()) {
            this.cleanUpInputFileChanged();
        }
        try {
            int childrenDone = 0;
            for (MapOperator.MapOpCtx current : this.currentCtxs) {
                if (current.forward(value)) continue;
                ++childrenDone;
            }
            this.rowsForwarded(childrenDone, ((VectorizedRowBatch)value).size);
        }
        catch (Exception e) {
            throw new HiveException("Hive Runtime Error while processing row ", e);
        }
    }
}

