/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAuditLoggerWithCommands {
    static final int NUM_DATA_NODES = 2;
    static final long seed = 3735928559L;
    static final int blockSize = 8192;
    private static MiniDFSCluster cluster = null;
    private static FileSystem fileSys = null;
    private static FileSystem fs2 = null;
    private static FileSystem fs = null;
    private static GenericTestUtils.LogCapturer auditlog;
    static Configuration conf;
    static UserGroupInformation user1;
    static UserGroupInformation user2;
    private static NamenodeProtocols proto;

    @BeforeClass
    public static void initialize() throws Exception {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
        user1 = UserGroupInformation.createUserForTesting((String)"theDoctor", (String[])new String[]{"tardis"});
        user2 = UserGroupInformation.createUserForTesting((String)"theEngineer", (String[])new String[]{"hadoop"});
        auditlog = GenericTestUtils.LogCapturer.captureLogs((Log)FSNamesystem.auditLog);
        proto = cluster.getNameNodeRpc();
        fileSys = DFSTestUtil.getFileSystemAs(user1, conf);
        fs2 = DFSTestUtil.getFileSystemAs(user2, conf);
        fs = cluster.getFileSystem();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        fs.close();
        fs2.close();
        fileSys.close();
        cluster.shutdown();
    }

    @Test
    public void testDelegationTokens() throws Exception {
        final Token dt = fs.getDelegationToken("foo");
        String getDT = ".*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*";
        this.verifyAuditLogs(true, ".*cmd=getDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        UserGroupInformation foo = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[0]);
        foo.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                dt.renew(conf);
                return null;
            }
        });
        this.verifyAuditLogs(true, ".*cmd=renewDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        try {
            dt.renew(conf);
            Assert.fail((String)"Renewing a token with non-renewer should fail");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(false, ".*cmd=renewDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        UserGroupInformation bar = UserGroupInformation.createUserForTesting((String)"bar", (String[])new String[0]);
        try {
            bar.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    dt.cancel(conf);
                    return null;
                }
            });
            Assert.fail((String)"Canceling a token with non-renewer should fail");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.verifyAuditLogs(false, ".*cmd=cancelDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
        dt.cancel(conf);
        this.verifyAuditLogs(true, ".*cmd=cancelDelegationToken.*src=HDFS_DELEGATION_TOKEN token 1.*with renewer foo.*");
    }

    private int verifyAuditLogs(boolean allowed, String pattern) {
        return this.verifyAuditLogs(".*allowed=" + allowed + pattern);
    }

    private int verifyAuditLogs(String pattern) {
        int length = auditlog.getOutput().split("\n").length;
        String lastAudit = auditlog.getOutput().split("\n")[length - 1];
        Assert.assertTrue((String)"Unexpected log!", (boolean)lastAudit.matches(pattern));
        return length;
    }

    private void removeExistingCachePools(String prevPool) throws Exception {
        BatchedRemoteIterator.BatchedEntries entries = proto.listCachePools(prevPool);
        for (int i = 0; i < entries.size(); ++i) {
            proto.removeCachePool(((CachePoolEntry)entries.get(i)).getInfo().getPoolName());
        }
    }
}

