/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Private
public class MultiStageMRConfigUtil {
    private static final String INITIAL_MAP_VERTEX_NAME = "initialmap";
    private static final String FINAL_REDUCE_VERTEX_NAME = "finalreduce";
    private static final String INTERMEDIATE_TASK_VERTEX_NAME_PREFIX = "ivertex";

    @InterfaceAudience.Private
    public static int getNumIntermediateStages(Configuration conf) {
        return conf.getInt("mrr.intermediate.num-stages", 0);
    }

    @InterfaceAudience.Private
    public static String getPropertyNameForIntermediateStage(int intermediateStage, String originalPropertyName) {
        return "mrr.intermediate.stage." + intermediateStage + "." + originalPropertyName;
    }

    @InterfaceAudience.Private
    public static String getInitialMapVertexName() {
        return INITIAL_MAP_VERTEX_NAME;
    }

    @InterfaceAudience.Private
    public static String getFinalReduceVertexName() {
        return FINAL_REDUCE_VERTEX_NAME;
    }

    @InterfaceAudience.Private
    public static String getIntermediateStageVertexName(int stageNum) {
        return INTERMEDIATE_TASK_VERTEX_NAME_PREFIX + stageNum;
    }

    @InterfaceAudience.Private
    static Configuration extractStageConf(Configuration baseConf, String prefix) {
        Configuration strippedConf = new Configuration(false);
        Configuration conf = new Configuration(false);
        for (Map.Entry entry : baseConf) {
            String key = (String)entry.getKey();
            if (key.startsWith(prefix)) {
                if (prefix.equals("") && key.startsWith("mrr.intermediate.stage.")) continue;
                String newKey = key.replace(prefix, "");
                strippedConf.set(newKey, (String)entry.getValue());
                continue;
            }
            if (key.startsWith("mrr.intermediate.stage.")) continue;
            conf.set(key, (String)entry.getValue());
        }
        for (Map.Entry entry : strippedConf) {
            if (Configuration.isDeprecated((String)((String)entry.getKey()))) continue;
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return conf;
    }
}

