/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigProgressable;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.parser.SourceLocation;
import org.apache.pig.pen.Illustrable;
import org.apache.pig.pen.Illustrator;
import org.apache.pig.pen.util.LineageTracer;

public abstract class PhysicalOperator
extends Operator<PhyPlanVisitor>
implements Illustrable,
Cloneable {
    private static final Log log = LogFactory.getLog(PhysicalOperator.class);
    protected static final long serialVersionUID = 1L;
    protected static final Result RESULT_EMPTY = new Result(1, null);
    protected static final Result RESULT_EOP = new Result(3, null);
    protected static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    protected static final BagFactory mBagFactory = BagFactory.getInstance();
    protected int requestedParallelism;
    protected List<PhysicalOperator> inputs;
    protected List<PhysicalOperator> outputs;
    protected byte resultType = (byte)110;
    protected PhysicalPlan parentPlan;
    protected boolean inputAttached = false;
    protected Tuple input = null;
    protected Result res = null;
    protected String alias = null;
    protected static ThreadLocal<PigProgressable> reporter = new ThreadLocal();
    protected static PigLogger pigLogger;
    protected LineageTracer lineageTracer;
    protected transient Illustrator illustrator = null;
    private boolean accum;
    private transient boolean accumStart;
    private List<OriginalLocation> originalLocations = new ArrayList<OriginalLocation>();

    public PhysicalOperator(OperatorKey k) {
        this(k, -1, null);
    }

    public PhysicalOperator(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public PhysicalOperator(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public PhysicalOperator(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k);
        this.requestedParallelism = rp;
        this.inputs = inp;
        this.res = new Result();
    }

    public PhysicalOperator(PhysicalOperator copy) {
        super(copy.getOperatorKey());
        this.res = new Result();
        this.requestedParallelism = copy.requestedParallelism;
        this.inputs = copy.inputs;
        this.outputs = copy.outputs;
        this.resultType = copy.resultType;
        this.parentPlan = copy.parentPlan;
        this.inputAttached = copy.inputAttached;
        this.alias = copy.alias;
        this.lineageTracer = copy.lineageTracer;
        this.accum = copy.accum;
        this.originalLocations = copy.originalLocations;
    }

    @Override
    public void setIllustrator(Illustrator illustrator) {
        this.illustrator = illustrator;
    }

    public Illustrator getIllustrator() {
        return this.illustrator;
    }

    public int getRequestedParallelism() {
        return this.requestedParallelism;
    }

    public void setRequestedParallelism(int requestedParallelism) {
        this.requestedParallelism = requestedParallelism;
    }

    public byte getResultType() {
        return this.resultType;
    }

    public String getAlias() {
        return this.alias;
    }

    protected String getAliasString() {
        return this.alias == null ? "" : this.alias + ": ";
    }

    public void copyAliasFrom(PhysicalOperator op) {
        this.alias = op.alias;
        this.originalLocations = op.originalLocations;
    }

    public void addOriginalLocation(String alias, SourceLocation sourceLocation) {
        this.alias = alias;
        this.originalLocations.add(new OriginalLocation(alias, sourceLocation.line(), sourceLocation.offset()));
    }

    public void addOriginalLocation(String alias, List<OriginalLocation> originalLocations) {
        this.alias = alias;
        this.originalLocations.addAll(originalLocations);
    }

    public List<OriginalLocation> getOriginalLocations() {
        return Collections.unmodifiableList(this.originalLocations);
    }

    public void setAccumulative() {
        this.accum = true;
    }

    public boolean isAccumulative() {
        return this.accum;
    }

    public void setAccumStart() {
        if (!this.accum) {
            throw new IllegalStateException("Accumulative is not turned on.");
        }
        this.accumStart = true;
    }

    public boolean isAccumStarted() {
        return this.accumStart;
    }

    public void setAccumEnd() {
        if (!this.accum) {
            throw new IllegalStateException("Accumulative is not turned on.");
        }
        this.accumStart = false;
    }

    public void setResultType(byte resultType) {
        this.resultType = resultType;
    }

    public List<PhysicalOperator> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<PhysicalOperator> inputs) {
        this.inputs = inputs;
    }

    public boolean isInputAttached() {
        return this.inputAttached;
    }

    public void attachInput(Tuple t) {
        this.input = t;
        this.inputAttached = true;
    }

    public void detachInput() {
        this.input = null;
        this.inputAttached = false;
    }

    public boolean isBlocking() {
        return false;
    }

    public Result processInput() throws ExecException {
        try {
            if (this.input == null && (this.inputs == null || this.inputs.size() == 0)) {
                return RESULT_EOP;
            }
            PigProgressable progRep = PhysicalOperator.getReporter();
            if (progRep != null) {
                progRep.progress();
            }
            if (!this.isInputAttached()) {
                return this.inputs.get(0).getNextTuple();
            }
            Result res = new Result();
            res.result = this.input;
            res.returnStatus = 0;
            this.detachInput();
            return res;
        }
        catch (ExecException e) {
            throw new ExecException("Exception while executing " + this.toString() + ": " + e.toString(), e);
        }
    }

    @Override
    public abstract void visit(PhyPlanVisitor var1) throws VisitorException;

    public Result getNext(byte dataType) throws ExecException {
        try {
            switch (dataType) {
                case 120: {
                    return this.getNextDataBag();
                }
                case 5: {
                    return this.getNextBoolean();
                }
                case 50: {
                    return this.getNextDataByteArray();
                }
                case 55: {
                    return this.getNextString();
                }
                case 25: {
                    return this.getNextDouble();
                }
                case 20: {
                    return this.getNextFloat();
                }
                case 10: {
                    return this.getNextInteger();
                }
                case 15: {
                    return this.getNextLong();
                }
                case 65: {
                    return this.getNextBigInteger();
                }
                case 70: {
                    return this.getNextBigDecimal();
                }
                case 30: {
                    return this.getNextDateTime();
                }
                case 100: {
                    return this.getNextMap();
                }
                case 110: {
                    return this.getNextTuple();
                }
            }
            throw new ExecException("Unsupported type for getNext: " + DataType.findTypeName(dataType));
        }
        catch (ExecException e) {
            throw new ExecException("Exception while executing for " + this.originalLocationsToDescriptiveString() + ": " + e.toString(), e.getErrorCode(), e);
        }
        catch (RuntimeException e) {
            throw new ExecException("Exception while executing " + this.toString() + ": " + e.toString(), e);
        }
    }

    private String originalLocationsToDescriptiveString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean isFirstItem = true;
        for (OriginalLocation ol : this.getOriginalLocations()) {
            if (isFirstItem) {
                isFirstItem = false;
            } else {
                sb.append(",");
            }
            sb.append(ol.getAlias()).append("[line=").append(ol.getLine()).append(",offset=").append(ol.getOffset()).append("]");
        }
        return sb.append(']').toString();
    }

    public Result getNextInteger() throws ExecException {
        return this.res;
    }

    public Result getNextLong() throws ExecException {
        return this.res;
    }

    public Result getNextDouble() throws ExecException {
        return this.res;
    }

    public Result getNextFloat() throws ExecException {
        return this.res;
    }

    public Result getNextDateTime() throws ExecException {
        return this.res;
    }

    public Result getNextString() throws ExecException {
        return this.res;
    }

    public Result getNextDataByteArray() throws ExecException {
        return this.res;
    }

    public Result getNextMap() throws ExecException {
        return this.res;
    }

    public Result getNextBoolean() throws ExecException {
        return this.res;
    }

    public Result getNextTuple() throws ExecException {
        return this.res;
    }

    public Result getNextDataBag() throws ExecException {
        Result val = new Result();
        DataBag tmpBag = mBagFactory.newDefaultBag();
        Result ret = this.getNextTuple();
        while (ret.returnStatus != 3) {
            if (ret.returnStatus == 2) {
                return ret;
            }
            if (ret.returnStatus != 1) {
                tmpBag.add((Tuple)ret.result);
            }
            ret = this.getNextTuple();
        }
        val.result = tmpBag;
        val.returnStatus = (byte)(tmpBag.size() == 0L ? 3 : 0);
        return val;
    }

    public Result getNextBigInteger() throws ExecException {
        return this.res;
    }

    public Result getNextBigDecimal() throws ExecException {
        return this.res;
    }

    public void reset() {
    }

    public boolean isEndOfAllInput() {
        return this.parentPlan.endOfAllInput;
    }

    public static PigProgressable getReporter() {
        return reporter.get();
    }

    public static void setReporter(PigProgressable reporter) {
        PhysicalOperator.reporter.set(reporter);
    }

    public static void staticDataCleanup() {
        reporter = new ThreadLocal();
    }

    @Override
    public PhysicalOperator clone() throws CloneNotSupportedException {
        return (PhysicalOperator)super.clone();
    }

    protected void cloneHelper(PhysicalOperator op) {
        this.resultType = op.resultType;
        this.originalLocations.addAll(op.originalLocations);
    }

    protected static List<PhysicalPlan> clonePlans(List<PhysicalPlan> origPlans) throws CloneNotSupportedException {
        ArrayList<PhysicalPlan> clonePlans = new ArrayList<PhysicalPlan>(origPlans.size());
        for (PhysicalPlan plan : origPlans) {
            clonePlans.add(plan.clone());
        }
        return clonePlans;
    }

    public void setParentPlan(PhysicalPlan physicalPlan) {
        this.parentPlan = physicalPlan;
    }

    public PhysicalPlan getParentPlan() {
        return this.parentPlan;
    }

    public Log getLogger() {
        return log;
    }

    public static void setPigLogger(PigLogger logger) {
        pigLogger = logger;
    }

    public static PigLogger getPigLogger() {
        return pigLogger;
    }

    public static class OriginalLocation
    implements Serializable {
        private String alias;
        private int line;
        private int offset;

        public OriginalLocation(String alias, int line, int offset) {
            this.alias = alias;
            this.line = line;
            this.offset = offset;
        }

        public String getAlias() {
            return this.alias;
        }

        public int getLine() {
            return this.line;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.alias + "[" + this.line + "," + this.offset + "]";
        }
    }
}

