/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;
import org.apache.pig.pen.util.LineageTracer;

public class PORank
extends PhysicalOperator {
    private static final Log log = LogFactory.getLog(PORank.class);
    private static final long serialVersionUID = 1L;
    private List<PhysicalPlan> rankPlans;
    private List<Boolean> mAscCols;
    private List<Byte> ExprOutputTypes;
    private String operationID;
    private int localCountIllustrator = 0;

    public PORank(OperatorKey k) {
        this(k, -1, null);
    }

    public PORank(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public PORank(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public PORank(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    public PORank(PORank copy) {
        super(copy);
        this.rankPlans = copy.rankPlans;
        this.mAscCols = copy.mAscCols;
        this.ExprOutputTypes = copy.ExprOutputTypes;
    }

    public PORank(OperatorKey operatorKey, int requestedParallelism, List inp, List<PhysicalPlan> rankPlans, List<Boolean> ascendingCol) {
        super(operatorKey, requestedParallelism, inp);
        this.setRankPlans(rankPlans);
        this.setAscendingCols(ascendingCol);
        this.ExprOutputTypes = new ArrayList<Byte>(rankPlans.size());
        for (PhysicalPlan plan : rankPlans) {
            this.ExprOutputTypes.add(((PhysicalOperator)plan.getLeaves().get(0)).getResultType());
        }
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            ExampleTuple tOut = new ExampleTuple((Tuple)out);
            this.illustrator.addData((Tuple)out);
            this.illustrator.getEquivalenceClasses().get(eqClassIndex).add((Tuple)in);
            LineageTracer lineageTracer = this.illustrator.getLineage();
            lineageTracer.insert(tOut);
            return tOut;
        }
        return (Tuple)out;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitRank(this);
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result inp;
        block1: {
            inp = null;
            do {
                inp = this.processInput();
                if (inp.returnStatus == 3 || inp.returnStatus == 2) break block1;
            } while (inp.returnStatus == 1);
            return this.addRank(inp);
        }
        return inp;
    }

    public Result addRank(Result input) throws ExecException {
        Tuple in = (Tuple)input.result;
        Long localCounter = (Long)in.get(0);
        Integer taskId = (Integer)in.getAll().remove(in.getAll().size() - 1);
        Long rank = this.getRankCounterOffset(taskId);
        in.set(0, rank + localCounter);
        if (this.localCountIllustrator > 2) {
            this.localCountIllustrator = 0;
        }
        input.result = this.illustratorMarkup(in, in, this.localCountIllustrator);
        ++this.localCountIllustrator;
        return input;
    }

    protected Long getRankCounterOffset(Integer taskId) {
        String nameCounter = "pig.counters.counter_" + this.getOperationID() + "_" + String.valueOf(taskId);
        Long rank = ((Configuration)PigMapReduce.sJobConfInternal.get()).getLong(nameCounter, -1L);
        if (this.illustrator != null) {
            rank = 0L;
        }
        if (rank == -1L) {
            log.error((Object)("Error on reading counter " + nameCounter));
            throw new RuntimeException("Unable to read counter " + nameCounter);
        }
        return rank;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public String name() {
        return this.getAliasString() + "PORank[" + DataType.findTypeName(this.resultType) + "] - " + this.mKey.toString();
    }

    public void setRankPlans(List<PhysicalPlan> rankPlans) {
        this.rankPlans = rankPlans;
    }

    public List<PhysicalPlan> getRankPlans() {
        return this.rankPlans;
    }

    public void setAscendingCols(List<Boolean> mAscCols) {
        this.mAscCols = mAscCols;
    }

    public List<Boolean> getAscendingCols() {
        return this.mAscCols;
    }

    public void setOperationID(String operationID) {
        this.operationID = operationID;
    }

    public String getOperationID() {
        return this.operationID;
    }

    @Override
    public PORank clone() throws CloneNotSupportedException {
        PORank clone = (PORank)super.clone();
        return clone;
    }
}

