/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.plan;

import java.io.PrintStream;
import java.util.LinkedList;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PlanPrinter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.NativeSparkOperator;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POGlobalRearrangeSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class SparkPrinter
extends SparkOpPlanVisitor {
    private PrintStream mStream = null;
    private boolean isVerbose = true;

    public SparkPrinter(PrintStream ps, SparkOperPlan plan) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DepthFirstWalker<SparkOperator, SparkOperPlan>(plan));
        this.mStream = ps;
        this.mStream.println("#--------------------------------------------------");
        this.mStream.println("# Spark Plan");
        this.mStream.println("#--------------------------------------------------");
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
        this.mStream.println("");
        this.mStream.println("Spark node " + sparkOp.getOperatorKey().toString());
        if (sparkOp instanceof NativeSparkOperator) {
            this.mStream.println(((NativeSparkOperator)sparkOp).getCommandString());
            this.mStream.println("--------");
            this.mStream.println();
            return;
        }
        if (sparkOp.physicalPlan != null && sparkOp.physicalPlan.size() > 0) {
            PlanPrinter printer = new PlanPrinter(sparkOp.physicalPlan, this.mStream);
            printer.setVerbose(this.isVerbose);
            printer.visit();
            this.mStream.println("--------");
        }
        LinkedList<POGlobalRearrangeSpark> glrList = PlanHelper.getPhysicalOperators(sparkOp.physicalPlan, POGlobalRearrangeSpark.class);
        for (POGlobalRearrangeSpark glr : glrList) {
            if (!glr.isUseSecondaryKey()) continue;
            this.mStream.println("POGlobalRearrange(" + glr.getOperatorKey() + ") uses secondaryKey");
        }
    }
}

