/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.SpillableMemoryManager;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class BagFactory {
    private static BagFactory gSelf = null;
    private static SpillableMemoryManager gMemMgr;

    public static BagFactory getInstance() {
        if (gSelf == null) {
            String factoryName = System.getProperty("pig.data.bag.factory.name");
            String factoryJar = System.getProperty("pig.data.bag.factory.jar");
            if (factoryName != null && factoryJar != null) {
                try {
                    URL[] urls = new URL[]{new URL(factoryJar)};
                    URLClassLoader loader = new URLClassLoader(urls, BagFactory.class.getClassLoader());
                    Class<?> c = Class.forName(factoryName, true, loader);
                    Object o = c.newInstance();
                    if (!(o instanceof BagFactory)) {
                        throw new RuntimeException("Provided factory " + factoryName + " does not extend BagFactory!");
                    }
                    gSelf = (BagFactory)o;
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)e;
                        throw re;
                    }
                    throw new RuntimeException("Unable to instantiate bag factory " + factoryName, e);
                }
            } else {
                gSelf = new DefaultBagFactory();
            }
        }
        return gSelf;
    }

    public abstract DataBag newDefaultBag();

    public abstract DataBag newDefaultBag(List<Tuple> var1);

    public abstract DataBag newLimitedSortedBag(Comparator<Tuple> var1, long var2);

    public abstract DataBag newSortedBag(Comparator<Tuple> var1);

    public abstract DataBag newDistinctBag();

    public DataBag newDistinctBag(Set<Tuple> tuples) {
        DataBag bag = this.newDistinctBag();
        for (Tuple t : tuples) {
            bag.add(t);
        }
        return bag;
    }

    protected BagFactory() {
        gMemMgr = SpillableMemoryManager.getInstance();
    }

    @Deprecated
    protected void registerBag(DataBag b) {
        gMemMgr.registerSpillable(b);
    }

    public static void resetSelf() {
        gSelf = null;
    }
}

