/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.FinishImportTable;
import org.apache.accumulo.server.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.tableOps.PopulateMetadataTable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class MoveExportedFiles
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    MoveExportedFiles(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        try {
            FileStatus[] files;
            FileSystem fs = master.getFileSystem();
            Map<String, String> fileNameMappings = PopulateMetadataTable.readMappingFile(fs, this.tableInfo);
            for (String oldFileName : fileNameMappings.keySet()) {
                if (fs.exists(new Path(this.tableInfo.exportDir, oldFileName))) continue;
                throw new ThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "File referenced by exported table does not exists " + oldFileName);
            }
            for (FileStatus fileStatus : files = fs.listStatus(new Path(this.tableInfo.exportDir))) {
                String newName = fileNameMappings.get(fileStatus.getPath().getName());
                if (newName == null) continue;
                fs.rename(fileStatus.getPath(), new Path(this.tableInfo.importDir, newName));
            }
            return new FinishImportTable(this.tableInfo);
        }
        catch (IOException ioe) {
            log.warn((Object)ioe.getMessage(), (Throwable)ioe);
            throw new ThriftTableOperationException(this.tableInfo.tableId, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error renaming files " + ioe.getMessage());
        }
    }
}

