/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.util.Set;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.AuditLevel;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AuditedSecurityOperation
extends SecurityOperation {
    public static final Logger log = Logger.getLogger(AuditedSecurityOperation.class);

    public AuditedSecurityOperation(Authorizor author, Authenticator authent, PermissionHandler pm, String instanceId) {
        super(author, authent, pm, instanceId);
    }

    public static synchronized SecurityOperation getInstance(String instanceId, boolean initialize) {
        if (instance == null) {
            instance = new AuditedSecurityOperation(AuditedSecurityOperation.getAuthorizor(instanceId, initialize), AuditedSecurityOperation.getAuthenticator(instanceId, initialize), AuditedSecurityOperation.getPermHandler(instanceId, initialize), instanceId);
        }
        return instance;
    }

    private void audit(TCredentials credentials, ThriftSecurityException ex, String template, Object ... args) {
        log.log((Priority)AuditLevel.AUDIT, (Object)("Error: authenticated operation failed: " + credentials.getPrincipal() + ": " + String.format(template, args)));
    }

    private void audit(TCredentials credentials, String template, Object ... args) {
        log.log((Priority)AuditLevel.AUDIT, (Object)("Using credentials " + credentials.getPrincipal() + ": " + String.format(template, args)));
    }

    @Override
    public boolean authenticateUser(TCredentials credentials, TCredentials toAuth) throws ThriftSecurityException {
        try {
            boolean result = super.authenticateUser(credentials, toAuth);
            this.audit(credentials, result ? "authenticated" : "failed authentication", new Object[0]);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "authenticateUser", new Object[0]);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public Authorizations getUserAuthorizations(TCredentials credentials, String user) throws ThriftSecurityException {
        try {
            Authorizations result = super.getUserAuthorizations(credentials, user);
            this.audit(credentials, "got authorizations for %s", user);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "getting authorizations for %s", user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public Authorizations getUserAuthorizations(TCredentials credentials) throws ThriftSecurityException {
        try {
            return this.getUserAuthorizations(credentials, credentials.getPrincipal());
        }
        catch (ThriftSecurityException ex) {
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void changeAuthorizations(TCredentials credentials, String user, Authorizations authorizations) throws ThriftSecurityException {
        try {
            super.changeAuthorizations(credentials, user, authorizations);
            this.audit(credentials, "changed authorizations for %s to %s", user, authorizations);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "changing authorizations for %s", user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void changePassword(TCredentials credentials, TCredentials newInfo) throws ThriftSecurityException {
        try {
            super.changePassword(credentials, newInfo);
            this.audit(credentials, "changed password for %s", newInfo.getPrincipal());
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "changing password for %s", newInfo.getPrincipal());
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void createUser(TCredentials credentials, TCredentials newUser, Authorizations authorizations) throws ThriftSecurityException {
        try {
            super.createUser(credentials, newUser, authorizations);
            this.audit(credentials, "createUser", new Object[0]);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "createUser %s", newUser.getPrincipal());
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void dropUser(TCredentials credentials, String user) throws ThriftSecurityException {
        try {
            super.dropUser(credentials, user);
            this.audit(credentials, "dropUser", new Object[0]);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "dropUser %s", user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void grantSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        try {
            super.grantSystemPermission(credentials, user, permission);
            this.audit(credentials, "granted permission %s for %s", permission, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "granting permission %s for %s", permission, user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void grantTablePermission(TCredentials credentials, String user, String table, TablePermission permission) throws ThriftSecurityException {
        try {
            super.grantTablePermission(credentials, user, table, permission);
            this.audit(credentials, "granted permission %s on table %s for %s", permission, table, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "granting permission %s on table for %s", permission, table, user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void revokeSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        try {
            super.revokeSystemPermission(credentials, user, permission);
            this.audit(credentials, "revoked permission %s for %s", permission, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "revoking permission %s on %s", permission, user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void revokeTablePermission(TCredentials credentials, String user, String table, TablePermission permission) throws ThriftSecurityException {
        try {
            super.revokeTablePermission(credentials, user, table, permission);
            this.audit(credentials, "revoked permission %s on table %s for %s", permission, table, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "revoking permission %s on table for %s", permission, table, user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public boolean hasSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        try {
            boolean result = super.hasSystemPermission(credentials, user, permission);
            this.audit(credentials, "checked permission %s on %s", permission, user);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "checking permission %s on %s", permission, user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public boolean hasTablePermission(TCredentials credentials, String user, String table, TablePermission permission) throws ThriftSecurityException {
        try {
            boolean result = super.hasTablePermission(credentials, user, table, permission);
            this.audit(credentials, "checked permission %s on table %s for %s", permission, table, user);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "checking permission %s on %s", permission, user);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public Set<String> listUsers(TCredentials credentials) throws ThriftSecurityException {
        try {
            Set<String> result = super.listUsers(credentials);
            this.audit(credentials, "listUsers", new Object[0]);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "listUsers", new Object[0]);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void deleteTable(TCredentials credentials, String table) throws ThriftSecurityException {
        try {
            super.deleteTable(credentials, table);
            this.audit(credentials, "deleted table %s", table);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, "deleting table %s", table);
            log.debug((Object)ex);
            throw ex;
        }
    }

    @Override
    public void initializeSecurity(TCredentials credentials, String principal, byte[] token) throws AccumuloSecurityException, ThriftSecurityException {
        super.initializeSecurity(credentials, principal, token);
        log.info((Object)("Initialized root user with username: " + principal + " at the request of user " + credentials.getPrincipal()));
    }
}

