/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.trace;

import java.io.IOException;
import java.net.URI;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.server.trace.TraceFSDataInputStream;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class TraceFileSystem
extends FileSystem {
    final FileSystem impl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConf(Configuration conf) {
        Span span = Trace.start((String)"setConf");
        try {
            if (this.impl != null) {
                this.impl.setConf(conf);
            } else {
                super.setConf(conf);
            }
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConf() {
        Span span = Trace.start((String)"getConf");
        try {
            Configuration configuration = this.impl.getConf();
            return configuration;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        Span span = Trace.start((String)"getFileBlockLocations");
        try {
            BlockLocation[] blockLocationArray = this.impl.getFileBlockLocations(file, start, len);
            return blockLocationArray;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataInputStream open(Path f) throws IOException {
        Span span = Trace.start((String)"open");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            TraceFSDataInputStream traceFSDataInputStream = new TraceFSDataInputStream(this.impl.open(f));
            return traceFSDataInputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, overwrite);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, progress);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, short replication) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, replication);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, replication, progress);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, overwrite, bufferSize);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, overwrite, bufferSize, progress);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, overwrite, bufferSize, replication, blockSize);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Span span = Trace.start((String)"create");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, overwrite, bufferSize, replication, blockSize, progress);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createNewFile(Path f) throws IOException {
        Span span = Trace.start((String)"createNewFile");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            boolean bl = this.impl.createNewFile(f);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream append(Path f) throws IOException {
        Span span = Trace.start((String)"append");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.append(f);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        Span span = Trace.start((String)"append");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.append(f, bufferSize);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public short getReplication(Path src) throws IOException {
        Span span = Trace.start((String)"getReplication");
        if (Trace.isTracing()) {
            span.data("path", src.toString());
        }
        try {
            short s = this.impl.getFileStatus(src).getReplication();
            return s;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setReplication(Path src, short replication) throws IOException {
        Span span = Trace.start((String)"setReplication");
        if (Trace.isTracing()) {
            span.data("path", src.toString());
        }
        try {
            boolean bl = this.impl.setReplication(src, replication);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Path f) throws IOException {
        Span span = Trace.start((String)"exists");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            boolean bl = this.impl.exists(f);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectory(Path f) throws IOException {
        Span span = Trace.start((String)"isDirectory");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            boolean bl = this.impl.getFileStatus(f).isDir();
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFile(Path f) throws IOException {
        Span span = Trace.start((String)"isFile");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            boolean bl = this.impl.isFile(f);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLength(Path f) throws IOException {
        Span span = Trace.start((String)"getLength");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            long l = this.impl.getLength(f);
            return l;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentSummary getContentSummary(Path f) throws IOException {
        Span span = Trace.start((String)"getContentSummary");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            ContentSummary contentSummary = this.impl.getContentSummary(f);
            return contentSummary;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
        Span span = Trace.start((String)"listStatus");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FileStatus[] fileStatusArray = this.impl.listStatus(f, filter);
            return fileStatusArray;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path[] files) throws IOException {
        Span span = Trace.start((String)"listStatus");
        try {
            FileStatus[] fileStatusArray = this.impl.listStatus(files);
            return fileStatusArray;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws IOException {
        Span span = Trace.start((String)"listStatus");
        try {
            FileStatus[] fileStatusArray = this.impl.listStatus(files, filter);
            return fileStatusArray;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        Span span = Trace.start((String)"globStatus");
        if (Trace.isTracing()) {
            span.data("pattern", pathPattern.toString());
        }
        try {
            FileStatus[] fileStatusArray = this.impl.globStatus(pathPattern);
            return fileStatusArray;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        Span span = Trace.start((String)"globStatus");
        if (Trace.isTracing()) {
            span.data("pattern", pathPattern.toString());
        }
        try {
            FileStatus[] fileStatusArray = this.impl.globStatus(pathPattern, filter);
            return fileStatusArray;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getHomeDirectory() {
        Span span = Trace.start((String)"getHomeDirectory");
        try {
            Path path = this.impl.getHomeDirectory();
            return path;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(Path f) throws IOException {
        Span span = Trace.start((String)"mkdirs");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            boolean bl = this.impl.mkdirs(f);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        Span span = Trace.start((String)"copyFromLocalFile");
        if (Trace.isTracing()) {
            span.data("src", src.toString());
            span.data("dst", dst.toString());
        }
        try {
            this.impl.copyFromLocalFile(src, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        Span span = Trace.start((String)"moveFromLocalFile");
        if (Trace.isTracing()) {
            span.data("dst", dst.toString());
        }
        try {
            this.impl.moveFromLocalFile(srcs, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        Span span = Trace.start((String)"moveFromLocalFile");
        if (Trace.isTracing()) {
            span.data("src", src.toString());
            span.data("dst", dst.toString());
        }
        try {
            this.impl.moveFromLocalFile(src, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        Span span = Trace.start((String)"copyFromLocalFile");
        if (Trace.isTracing()) {
            span.data("src", src.toString());
            span.data("dst", dst.toString());
        }
        try {
            this.impl.copyFromLocalFile(delSrc, src, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        Span span = Trace.start((String)"copyFromLocalFile");
        if (Trace.isTracing()) {
            span.data("dst", dst.toString());
        }
        try {
            this.impl.copyFromLocalFile(delSrc, overwrite, srcs, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        Span span = Trace.start((String)"copyFromLocalFile");
        if (Trace.isTracing()) {
            span.data("src", src.toString());
            span.data("dst", dst.toString());
        }
        try {
            this.impl.copyFromLocalFile(delSrc, overwrite, src, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToLocalFile(Path src, Path dst) throws IOException {
        Span span = Trace.start((String)"copyFromLocalFile");
        if (Trace.isTracing()) {
            span.data("src", src.toString());
            span.data("dst", dst.toString());
        }
        try {
            this.impl.copyToLocalFile(src, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToLocalFile(Path src, Path dst) throws IOException {
        Span span = Trace.start((String)"moveToLocalFile");
        if (Trace.isTracing()) {
            span.data("src", src.toString());
            span.data("dst", dst.toString());
        }
        try {
            this.impl.moveToLocalFile(src, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        Span span = Trace.start((String)"copyToLocalFile");
        if (Trace.isTracing()) {
            span.data("src", src.toString());
            span.data("dst", dst.toString());
        }
        try {
            this.impl.copyToLocalFile(delSrc, src, dst);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        Span span = Trace.start((String)"startLocalOutput");
        if (Trace.isTracing()) {
            span.data("out", fsOutputFile.toString());
            span.data("local", tmpLocalFile.toString());
        }
        try {
            Path path = this.impl.startLocalOutput(fsOutputFile, tmpLocalFile);
            return path;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        Span span = Trace.start((String)"completeLocalOutput");
        if (Trace.isTracing()) {
            span.data("out", fsOutputFile.toString());
            span.data("local", tmpLocalFile.toString());
        }
        try {
            this.impl.completeLocalOutput(fsOutputFile, tmpLocalFile);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Span span = Trace.start((String)"close");
        try {
            this.impl.close();
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsed() throws IOException {
        Span span = Trace.start((String)"getUsed");
        try {
            long l = this.impl.getUsed();
            return l;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBlockSize(Path f) throws IOException {
        Span span = Trace.start((String)"getBlockSize");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            long l = this.impl.getBlockSize(f);
            return l;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDefaultBlockSize() {
        Span span = Trace.start((String)"getDefaultBlockSize");
        try {
            long l = this.impl.getDefaultBlockSize();
            return l;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getDefaultReplication() {
        Span span = Trace.start((String)"getDefaultReplication");
        try {
            short s = this.impl.getDefaultReplication();
            return s;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChecksum getFileChecksum(Path f) throws IOException {
        Span span = Trace.start((String)"getFileChecksum");
        if (Trace.isTracing()) {
            span.data("path", f.toString());
        }
        try {
            FileChecksum fileChecksum = this.impl.getFileChecksum(f);
            return fileChecksum;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVerifyChecksum(boolean verifyChecksum) {
        Span span = Trace.start((String)"setVerifyChecksum");
        try {
            this.impl.setVerifyChecksum(verifyChecksum);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermission(Path p, FsPermission permission) throws IOException {
        Span span = Trace.start((String)"setPermission");
        if (Trace.isTracing()) {
            span.data("path", p.toString());
        }
        try {
            this.impl.setPermission(p, permission);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(Path p, String username, String groupname) throws IOException {
        Span span = Trace.start((String)"setOwner");
        if (Trace.isTracing()) {
            span.data("path", p.toString());
            span.data("user", username);
            span.data("group", groupname);
        }
        try {
            this.impl.setOwner(p, username, groupname);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        Span span = Trace.start((String)"setTimes");
        try {
            this.impl.setTimes(p, mtime, atime);
        }
        finally {
            span.stop();
        }
    }

    TraceFileSystem(FileSystem impl) {
        ArgumentChecker.notNull((Object)impl);
        this.impl = impl;
    }

    public FileSystem getImplementation() {
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getUri() {
        Span span = Trace.start((String)"getUri");
        try {
            URI uRI = this.impl.getUri();
            return uRI;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        Span span = Trace.start((String)"open");
        try {
            TraceFSDataInputStream traceFSDataInputStream = new TraceFSDataInputStream(this.impl.open(f, bufferSize));
            return traceFSDataInputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Span span = Trace.start((String)"create");
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.create(f, overwrite, bufferSize, replication, blockSize, progress);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(URI name, Configuration conf) throws IOException {
        Span span = Trace.start((String)"initialize");
        try {
            this.impl.initialize(name, conf);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        Span span = Trace.start((String)"append");
        try {
            FSDataOutputStream fSDataOutputStream = this.impl.append(f, bufferSize, progress);
            return fSDataOutputStream;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(Path src, Path dst) throws IOException {
        Span span = Trace.start((String)"rename");
        try {
            boolean bl = this.impl.rename(src, dst);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Path f) throws IOException {
        Span span = Trace.start((String)"delete");
        try {
            boolean bl = this.impl.delete(f);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Path f, boolean recursive) throws IOException {
        Span span = Trace.start((String)"delete");
        try {
            boolean bl = this.impl.delete(f, recursive);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path f) throws IOException {
        Span span = Trace.start((String)"listStatus");
        try {
            FileStatus[] fileStatusArray = this.impl.listStatus(f);
            return fileStatusArray;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorkingDirectory(Path new_dir) {
        Span span = Trace.start((String)"setWorkingDirectory");
        try {
            this.impl.setWorkingDirectory(new_dir);
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getWorkingDirectory() {
        Span span = Trace.start((String)"getWorkingDirectory");
        try {
            Path path = this.impl.getWorkingDirectory();
            return path;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        Span span = Trace.start((String)"mkdirs");
        try {
            boolean bl = this.impl.mkdirs(f, permission);
            return bl;
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus getFileStatus(Path f) throws IOException {
        Span span = Trace.start((String)"getFileStatus");
        try {
            FileStatus fileStatus = this.impl.getFileStatus(f);
            return fileStatus;
        }
        finally {
            span.stop();
        }
    }

    public static FileSystem wrap(FileSystem fileSystem) {
        return new TraceFileSystem(fileSystem);
    }

    public static FileSystem getAndWrap(Configuration conf) throws IOException {
        return TraceFileSystem.wrap(FileSystem.get((Configuration)conf));
    }
}

