/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iterators.system.ColumnQualifierFilter;
import org.apache.accumulo.core.iterators.system.DeletingIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.iterators.system.VisibilityFilter;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class OfflineMetadataScanner
extends ScannerOptions
implements Scanner {
    private Set<String> allFiles = new HashSet<String>();
    private Range range = new Range();
    private final FileSystem fs;
    private final AccumuloConfiguration conf;

    private List<SortedKeyValueIterator<Key, Value>> openMapFiles(Collection<String> files, FileSystem fs, AccumuloConfiguration conf) throws IOException {
        ArrayList<SortedKeyValueIterator<Key, Value>> readers = new ArrayList<SortedKeyValueIterator<Key, Value>>();
        for (String file : files) {
            FileSKVIterator reader = FileOperations.getInstance().openReader(file, true, fs, fs.getConf(), conf);
            readers.add((SortedKeyValueIterator<Key, Value>)reader);
        }
        return readers;
    }

    private SortedKeyValueIterator<Key, Value> createSystemIter(Range r, List<SortedKeyValueIterator<Key, Value>> readers, HashSet<Column> columns) throws IOException {
        MultiIterator multiIterator = new MultiIterator(readers, false);
        DeletingIterator delIter = new DeletingIterator((SortedKeyValueIterator)multiIterator, false);
        ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator((SortedKeyValueIterator)delIter);
        ColumnQualifierFilter colFilter = new ColumnQualifierFilter((SortedKeyValueIterator)cfsi, columns);
        VisibilityFilter visFilter = new VisibilityFilter((SortedKeyValueIterator)colFilter, Constants.NO_AUTHS, new byte[0]);
        visFilter.seek(r, (Collection)LocalityGroupUtil.EMPTY_CF_SET, false);
        VersioningIterator vi = new VersioningIterator();
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("maxVersions", "1");
        vi.init((SortedKeyValueIterator)visFilter, opts, null);
        return vi;
    }

    public OfflineMetadataScanner(AccumuloConfiguration conf, FileSystem fs) throws IOException {
        FileStatus[] rootFiles;
        List<MetadataTable.LogEntry> rwal;
        this.fs = fs;
        this.conf = conf;
        try {
            rwal = MetadataTable.getLogEntries(null, Constants.ROOT_TABLET_EXTENT);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to check if root tablet has write ahead log entries", e);
        }
        if (rwal.size() > 0) {
            throw new RuntimeException("Root tablet has write ahead logs, can not scan offline");
        }
        for (FileStatus rootFile : rootFiles = fs.listStatus(new Path(ServerConstants.getRootTabletDir()))) {
            this.allFiles.add(rootFile.getPath().toString());
        }
        List<SortedKeyValueIterator<Key, Value>> readers = this.openMapFiles(this.allFiles, fs, conf);
        HashSet<Column> columns = new HashSet<Column>();
        columns.add(new Column(TextUtil.getBytes((Text)Constants.METADATA_DATAFILE_COLUMN_FAMILY), null, null));
        columns.add(new Column(TextUtil.getBytes((Text)Constants.METADATA_LOG_COLUMN_FAMILY), null, null));
        SortedKeyValueIterator<Key, Value> ssi = this.createSystemIter(new Range(), readers, columns);
        int walogs = 0;
        while (ssi.hasTop()) {
            if (((Key)ssi.getTopKey()).compareColumnFamily(Constants.METADATA_DATAFILE_COLUMN_FAMILY) == 0) {
                this.allFiles.add(ServerConstants.getMetadataTableDir() + "/" + ((Key)ssi.getTopKey()).getColumnQualifier().toString());
            } else {
                ++walogs;
            }
            ssi.next();
        }
        this.closeReaders(readers);
        if (walogs > 0) {
            throw new RuntimeException("Metadata tablets have write ahead logs, can not scan offline");
        }
    }

    private void closeReaders(List<SortedKeyValueIterator<Key, Value>> readers) throws IOException {
        for (SortedKeyValueIterator<Key, Value> reader : readers) {
            ((FileSKVIterator)reader).close();
        }
    }

    public int getBatchSize() {
        throw new UnsupportedOperationException();
    }

    public Range getRange() {
        return this.range;
    }

    @Deprecated
    public int getTimeOut() {
        throw new UnsupportedOperationException();
    }

    public Iterator<Map.Entry<Key, Value>> iterator() {
        SortedKeyValueIterator<Key, Value> ssi;
        try {
            List<SortedKeyValueIterator<Key, Value>> readers = this.openMapFiles(this.allFiles, this.fs, this.conf);
            ssi = this.createSystemIter(this.range, readers, new HashSet<Column>(this.getFetchedColumns()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Iterator<Map.Entry<Key, Value>>(){

            @Override
            public boolean hasNext() {
                return ssi.hasTop() && OfflineMetadataScanner.this.range.contains((Key)ssi.getTopKey());
            }

            @Override
            public Map.Entry<Key, Value> next() {
                if (!ssi.hasTop()) {
                    throw new NoSuchElementException();
                }
                MyEntry e = new MyEntry(new Key((Key)ssi.getTopKey()), new Value((Value)ssi.getTopValue()));
                try {
                    ssi.next();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
                return e;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setBatchSize(int size) {
        throw new UnsupportedOperationException();
    }

    public void setRange(Range range) {
        this.range = range;
    }

    @Deprecated
    public void setTimeOut(int timeOut) {
        throw new UnsupportedOperationException();
    }

    public void enableIsolation() {
    }

    public void disableIsolation() {
    }

    public static void main(String[] args) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)CachedConfiguration.getInstance());
        ServerConfiguration conf = new ServerConfiguration(HdfsZooInstance.getInstance());
        OfflineMetadataScanner scanner = new OfflineMetadataScanner(conf.getConfiguration(), fs);
        scanner.setRange(Constants.METADATA_KEYSPACE);
        Iterator<Map.Entry<Key, Value>> i$ = scanner.iterator();
        while (i$.hasNext()) {
            Map.Entry<Key, Value> entry = i$.next();
            System.out.println(entry.getKey() + " " + entry.getValue());
        }
    }

    private static class MyEntry
    implements Map.Entry<Key, Value> {
        private Key k;
        private Value v;

        MyEntry(Key k, Value v) {
            this.k = k;
            this.v = v;
        }

        @Override
        public Key getKey() {
            return this.k;
        }

        @Override
        public Value getValue() {
            return this.v;
        }

        @Override
        public Value setValue(Value value) {
            throw new UnsupportedOperationException();
        }
    }
}

