/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.yarn.ApplicationMaster$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q2Q!\u0001\u0002\u0001\r1\u00111$W1s]\u000ecWo\u001d;feN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$'BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT!!\u0002\u0004\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u0005\u0011\u0011B\u0001\t\u0003\u0005QI\u0016M\u001d8TG\",G-\u001e7fe\n\u000b7m[3oI\"AQ\u0001\u0001B\u0001B\u0003%1c\u0001\u0001\u0011\u0005Q)R\"\u0001\u0003\n\u0005Y!!!\u0005+bg.\u001c6\r[3ek2,'/S7qY\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011$\u0001\u0002tGB\u0011!dG\u0007\u0002\r%\u0011AD\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006=\u0001!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\n#\u0005\u0005\u0002\u000f\u0001!)Q!\ba\u0001'!)\u0001$\ba\u00013!)A\u0005\u0001C!K\u0005)1\u000f^1siR\ta\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0003V]&$\b\"B\u0017\u0001\t\u0003r\u0013\u0001E4fi\u0012\u0013\u0018N^3s\u0019><WK\u001d7t+\u0005y\u0003cA\u00141e%\u0011\u0011\u0007\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tM2\u0014(\u000f\b\u0003OQJ!!\u000e\u0015\u0002\rA\u0013X\rZ3g\u0013\t9\u0004HA\u0002NCBT!!\u000e\u0015\u0011\u0005MR\u0014BA\u001e9\u0005\u0019\u0019FO]5oO\u0002")
public class YarnClusterSchedulerBackend
extends YarnSchedulerBackend {
    private final SparkContext sc;

    @Override
    public void start() {
        ApplicationAttemptId attemptId = ApplicationMaster$.MODULE$.getAttemptId();
        this.bindToYarn(attemptId.getApplicationId(), (Option<ApplicationAttemptId>)new Some((Object)attemptId));
        super.start();
        this.totalExpectedExecutors_$eq(SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.sc.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    public Option<Map<String, String>> getDriverLogUrls() {
        void var1_1;
        None$ driverLogs = None$.MODULE$;
        try {
            YarnConfiguration yarnConf = new YarnConfiguration(this.sc.hadoopConfiguration());
            ContainerId containerId = YarnSparkHadoopUtil$.MODULE$.getContainerId();
            String httpAddress = new StringBuilder().append((Object)System.getenv(ApplicationConstants.Environment.NM_HOST.name())).append((Object)":").append((Object)System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name())).toString();
            String yarnHttpPolicy = yarnConf.get("yarn.http.policy", YarnConfiguration.YARN_HTTP_POLICY_DEFAULT);
            String user = Utils$.MODULE$.getCurrentUserName();
            String string = yarnHttpPolicy;
            String string2 = "HTTPS_ONLY";
            String httpScheme = !(string != null ? !string.equals(string2) : string2 != null) ? "https://" : "http://";
            String baseUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "/node/containerlogs/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{httpScheme, httpAddress, containerId, user}));
            this.logDebug((Function0)new Serializable(this, baseUrl){
                public static final long serialVersionUID = 0L;
                private final String baseUrl$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Base URL for logs: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.baseUrl$1}));
                }
                {
                    this.baseUrl$1 = baseUrl$1;
                }
            });
            driverLogs = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stdout"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stdout?start=-4096"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stderr"), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/stderr?start=-4096"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl})))})));
        }
        catch (Exception exception) {
            this.logInfo((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while building AM log links, so AM logs link will not appear in application UI";
                }
            }, exception);
        }
        return var1_1;
    }

    public YarnClusterSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.sc = sc;
        super(scheduler, sc);
    }
}

