/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.ZooSession;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZooReader
implements IZooReader {
    protected String keepers;
    protected int timeout;

    protected ZooKeeper getSession(String keepers, int timeout, String scheme, byte[] auth) {
        return ZooSession.getSession(keepers, timeout, scheme, auth);
    }

    protected ZooKeeper getZooKeeper() {
        return this.getSession(this.keepers, this.timeout, null, null);
    }

    @Override
    public byte[] getData(String zPath, Stat stat) throws KeeperException, InterruptedException {
        return this.getZooKeeper().getData(zPath, false, stat);
    }

    @Override
    public Stat getStatus(String zPath) throws KeeperException, InterruptedException {
        return this.getZooKeeper().exists(zPath, false);
    }

    @Override
    public Stat getStatus(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        return this.getZooKeeper().exists(zPath, watcher);
    }

    @Override
    public List<String> getChildren(String zPath) throws KeeperException, InterruptedException {
        return this.getZooKeeper().getChildren(zPath, false);
    }

    @Override
    public List<String> getChildren(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        return this.getZooKeeper().getChildren(zPath, watcher);
    }

    @Override
    public boolean exists(String zPath) throws KeeperException, InterruptedException {
        return this.getZooKeeper().exists(zPath, false) != null;
    }

    @Override
    public boolean exists(String zPath, Watcher watcher) throws KeeperException, InterruptedException {
        return this.getZooKeeper().exists(zPath, watcher) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(String path) throws KeeperException, InterruptedException {
        final AtomicInteger rc = new AtomicInteger();
        final AtomicBoolean waiter = new AtomicBoolean(false);
        this.getZooKeeper().sync(path, new AsyncCallback.VoidCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResult(int code, String arg1, Object arg2) {
                rc.set(code);
                AtomicBoolean atomicBoolean = waiter;
                synchronized (atomicBoolean) {
                    waiter.set(true);
                    waiter.notifyAll();
                }
            }
        }, null);
        AtomicBoolean atomicBoolean = waiter;
        synchronized (atomicBoolean) {
            while (!waiter.get()) {
                waiter.wait();
            }
        }
        KeeperException.Code code = KeeperException.Code.get((int)rc.get());
        if (code != KeeperException.Code.OK) {
            throw KeeperException.create((KeeperException.Code)code);
        }
    }

    public ZooReader(String keepers, int timeout) {
        this.keepers = keepers;
        this.timeout = timeout;
    }
}

