/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.events;

import com.google.common.collect.Maps;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.recovery.records.RecoveryProtos;
import org.apache.tez.runtime.api.InputSpecUpdate;

public class VertexConfigurationDoneEvent
implements HistoryEvent {
    private TezVertexID vertexID;
    private long reconfigureDoneTime;
    private int numTasks;
    private VertexLocationHint vertexLocationHint;
    private Map<String, EdgeProperty> sourceEdgeProperties;
    private Map<String, InputSpecUpdate> rootInputSpecUpdates;
    private boolean setParallelismCalledFlag;

    public VertexConfigurationDoneEvent() {
    }

    public VertexConfigurationDoneEvent(TezVertexID vertexID, long reconfigureDoneTime, int numTasks, VertexLocationHint vertexLocationHint, Map<String, EdgeProperty> sourceEdgeProperties, Map<String, InputSpecUpdate> rootInputSpecUpdates, boolean setParallelismCalledFlag) {
        this.vertexID = vertexID;
        this.reconfigureDoneTime = reconfigureDoneTime;
        this.numTasks = numTasks;
        this.vertexLocationHint = vertexLocationHint;
        this.sourceEdgeProperties = sourceEdgeProperties;
        this.rootInputSpecUpdates = rootInputSpecUpdates;
        this.setParallelismCalledFlag = setParallelismCalledFlag;
    }

    @Override
    public HistoryEventType getEventType() {
        return HistoryEventType.VERTEX_CONFIGURE_DONE;
    }

    @Override
    public boolean isRecoveryEvent() {
        return true;
    }

    @Override
    public boolean isHistoryEvent() {
        return true;
    }

    public RecoveryProtos.VertexConfigurationDoneProto toProto() {
        RecoveryProtos.VertexConfigurationDoneProto.Builder builder = RecoveryProtos.VertexConfigurationDoneProto.newBuilder();
        builder.setVertexId(this.vertexID.toString()).setReconfigureDoneTime(this.reconfigureDoneTime).setSetParallelismCalledFlag(this.setParallelismCalledFlag).setNumTasks(this.numTasks);
        if (this.vertexLocationHint != null) {
            builder.setVertexLocationHint(DagTypeConverters.convertVertexLocationHintToProto((VertexLocationHint)this.vertexLocationHint));
        }
        if (this.sourceEdgeProperties != null) {
            for (Map.Entry<String, EdgeProperty> entry : this.sourceEdgeProperties.entrySet()) {
                RecoveryProtos.EdgeManagerDescriptorProto.Builder edgeMgrBuilder = RecoveryProtos.EdgeManagerDescriptorProto.newBuilder();
                edgeMgrBuilder.setEdgeName(entry.getKey());
                edgeMgrBuilder.setEdgeProperty(DagTypeConverters.convertToProto((EdgeProperty)entry.getValue()));
                builder.addEdgeManagerDescriptors(edgeMgrBuilder.build());
            }
        }
        if (this.rootInputSpecUpdates != null) {
            for (Map.Entry<String, EdgeProperty> entry : this.rootInputSpecUpdates.entrySet()) {
                RecoveryProtos.RootInputSpecUpdateProto.Builder rootInputSpecUpdateBuilder = RecoveryProtos.RootInputSpecUpdateProto.newBuilder();
                rootInputSpecUpdateBuilder.setInputName(entry.getKey());
                rootInputSpecUpdateBuilder.setForAllWorkUnits(((InputSpecUpdate)entry.getValue()).isForAllWorkUnits());
                rootInputSpecUpdateBuilder.addAllNumPhysicalInputs(((InputSpecUpdate)entry.getValue()).getAllNumPhysicalInputs());
                builder.addRootInputSpecUpdates(rootInputSpecUpdateBuilder.build());
            }
        }
        return builder.build();
    }

    public void fromProto(RecoveryProtos.VertexConfigurationDoneProto proto) {
        this.vertexID = TezVertexID.fromString((String)proto.getVertexId());
        this.reconfigureDoneTime = proto.getReconfigureDoneTime();
        this.setParallelismCalledFlag = proto.getSetParallelismCalledFlag();
        this.numTasks = proto.getNumTasks();
        if (proto.hasVertexLocationHint()) {
            this.vertexLocationHint = DagTypeConverters.convertVertexLocationHintFromProto((DAGProtos.VertexLocationHintProto)proto.getVertexLocationHint());
        }
        if (proto.getEdgeManagerDescriptorsCount() > 0) {
            this.sourceEdgeProperties = new HashMap<String, EdgeProperty>(proto.getEdgeManagerDescriptorsCount());
            for (RecoveryProtos.EdgeManagerDescriptorProto edgeManagerProto : proto.getEdgeManagerDescriptorsList()) {
                EdgeProperty edgeProperty = DagTypeConverters.convertFromProto((DAGProtos.PlanEdgeProperty)edgeManagerProto.getEdgeProperty());
                this.sourceEdgeProperties.put(edgeManagerProto.getEdgeName(), edgeProperty);
            }
        }
        if (proto.getRootInputSpecUpdatesCount() > 0) {
            this.rootInputSpecUpdates = Maps.newHashMap();
            for (RecoveryProtos.RootInputSpecUpdateProto rootInputSpecUpdateProto : proto.getRootInputSpecUpdatesList()) {
                InputSpecUpdate specUpdate = rootInputSpecUpdateProto.getForAllWorkUnits() ? InputSpecUpdate.createAllTaskInputSpecUpdate((int)rootInputSpecUpdateProto.getNumPhysicalInputs(0)) : InputSpecUpdate.createPerTaskInputSpecUpdate(rootInputSpecUpdateProto.getNumPhysicalInputsList());
                this.rootInputSpecUpdates.put(rootInputSpecUpdateProto.getInputName(), specUpdate);
            }
        }
    }

    @Override
    public void toProtoStream(CodedOutputStream outputStream) throws IOException {
        outputStream.writeMessageNoTag((MessageLite)this.toProto());
    }

    @Override
    public void fromProtoStream(CodedInputStream inputStream) throws IOException {
        RecoveryProtos.VertexConfigurationDoneProto proto = (RecoveryProtos.VertexConfigurationDoneProto)inputStream.readMessage(RecoveryProtos.VertexConfigurationDoneProto.PARSER, null);
        if (proto == null) {
            throw new IOException("No data found in stream");
        }
        this.fromProto(proto);
    }

    public String toString() {
        return "vertexId=" + this.vertexID + ", reconfigureDoneTime=" + this.reconfigureDoneTime + ", numTasks=" + this.numTasks + ", vertexLocationHint=" + (this.vertexLocationHint == null ? "null" : this.vertexLocationHint) + ", edgeManagersCount=" + (this.sourceEdgeProperties == null ? "null" : Integer.valueOf(this.sourceEdgeProperties.size())) + ", rootInputSpecUpdateCount=" + (this.rootInputSpecUpdates == null ? "null" : Integer.valueOf(this.rootInputSpecUpdates.size())) + ", setParallelismCalledFlag=" + this.setParallelismCalledFlag;
    }

    public TezVertexID getVertexID() {
        return this.vertexID;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public VertexLocationHint getVertexLocationHint() {
        return this.vertexLocationHint;
    }

    public Map<String, EdgeProperty> getSourceEdgeProperties() {
        return this.sourceEdgeProperties;
    }

    public Map<String, InputSpecUpdate> getRootInputSpecUpdates() {
        return this.rootInputSpecUpdates;
    }

    public long getReconfigureDoneTime() {
        return this.reconfigureDoneTime;
    }

    public boolean isSetParallelismCalled() {
        return this.setParallelismCalledFlag;
    }
}

