/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.Set;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.BindingLoadPlacementNode;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingLoadPlacementProblem
extends DataFlowProblem {
    private Set<Variable> _initLoadsOnExit = new HashSet<Variable>();
    private boolean _bindingHasEscaped = false;

    public BindingLoadPlacementProblem() {
        super(DataFlowProblem.DF_Direction.BACKWARD);
    }

    @Override
    public String getName() {
        return "Binding Loads Placement Analysis";
    }

    @Override
    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new BindingLoadPlacementNode(this, bb);
    }

    @Override
    public String getDataFlowVarsForOutput() {
        return "";
    }

    public void initLoadsOnScopeExit(Set<Variable> loads) {
        this._initLoadsOnExit = loads;
    }

    public Set<Variable> getLoadsOnScopeExit() {
        return this._initLoadsOnExit;
    }

    public boolean bindingHasEscaped() {
        return this._bindingHasEscaped;
    }

    public void setBindingHasEscaped(boolean flag) {
        this._bindingHasEscaped = flag;
    }

    public boolean scopeDefinesVariable(Variable v) {
        return this.getCFG().definesLocalVariable(v);
    }

    public boolean scopeUsesVariable(Variable v) {
        return this.getCFG().usesLocalVariable(v);
    }

    public void addLoads() {
        for (FlowGraphNode n : this._fgNodes) {
            BindingLoadPlacementNode blpn = (BindingLoadPlacementNode)n;
            blpn.addLoads();
        }
    }
}

