/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.BiVariable;
import org.jruby.embed.variable.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class LocalGlobalVariable
extends GlobalVariable {
    private static String pattern = "([a-zA-Z]|(_([a-zA-Z]|_|\\d)))([a-zA-Z]|_|\\d)*";

    public static BiVariable getInstance(RubyObject receiver2, String name2, Object ... javaObject) {
        if (name2.matches(pattern)) {
            return new LocalGlobalVariable(receiver2, name2, javaObject);
        }
        return null;
    }

    private LocalGlobalVariable(RubyObject receiver2, String name2, Object ... javaObject) {
        super(receiver2, name2, javaObject);
    }

    LocalGlobalVariable(IRubyObject receiver2, String name2, IRubyObject irubyObject) {
        super(receiver2, name2, irubyObject);
    }

    public static void retrieve(RubyObject receiver2, BiVariableMap vars) {
        if (vars.isLazy()) {
            return;
        }
        GlobalVariables gvars = receiver2.getRuntime().getGlobalVariables();
        Set<String> names2 = gvars.getNames();
        for (String name2 : names2) {
            if (LocalGlobalVariable.isPredefined(name2)) continue;
            IRubyObject value2 = gvars.get(name2);
            String javaName = name2.substring(1);
            LocalGlobalVariable.updateLocalGlobal((RubyObject)receiver2.getRuntime().getTopSelf(), vars, javaName, value2);
        }
    }

    private static void updateLocalGlobal(RubyObject receiver2, BiVariableMap vars, String name2, IRubyObject value2) {
        if (vars.containsKey(name2)) {
            BiVariable var = vars.getVariable(receiver2, name2);
            var.setRubyObject(value2);
        } else {
            LocalGlobalVariable var = new LocalGlobalVariable((IRubyObject)receiver2, name2, value2);
            vars.update(name2, var);
        }
    }

    public static void retrieveByKey(Ruby runtime2, BiVariableMap vars, String key2) {
        GlobalVariables gvars = runtime2.getGlobalVariables();
        String rubyKey = ("$" + key2).intern();
        if (!gvars.getNames().contains(rubyKey)) {
            return;
        }
        IRubyObject value2 = gvars.get(rubyKey);
        LocalGlobalVariable.updateLocalGlobal((RubyObject)runtime2.getTopSelf(), vars, key2, value2);
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.LocalGlobalVariable;
    }

    public static boolean isValidName(Object name2) {
        return LocalGlobalVariable.isValidName(pattern, name2);
    }

    public void inject() {
        this.receiver.getRuntime().getGlobalVariables().set(("$" + this.name).intern(), this.irubyObject);
    }

    public void remove() {
        this.receiver.getRuntime().getGlobalVariables().clear(("$" + this.name).intern());
    }
}

