/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import com.esotericsoftware.kryo.Serializer;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.shims.HadoopShimsSecure;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.pig.EvalFunc;
import org.apache.pig.builtin.FuncUtils;
import org.apache.pig.builtin.HiveUDAF;
import org.apache.pig.builtin.HiveUDF;
import org.apache.pig.builtin.HiveUDTF;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.impl.util.hive.HiveUtils;
import org.apache.pig.tools.pigstats.PigStatusReporter;

abstract class HiveUDFBase
extends EvalFunc<Object> {
    HiveUDFBase() {
    }

    protected static Class resolveFunc(String funcName) throws IOException {
        Class udfClass;
        String className = funcName;
        if (FunctionRegistry.getFunctionNames().contains(funcName)) {
            FunctionInfo func;
            try {
                func = FunctionRegistry.getFunctionInfo((String)funcName);
            }
            catch (SemanticException e) {
                throw new IOException(e);
            }
            udfClass = func.getFunctionClass();
        } else {
            udfClass = PigContext.resolveClassName(className);
            if (udfClass == null) {
                throw new IOException("Cannot find Hive UDF " + funcName);
            }
        }
        return udfClass;
    }

    protected static MapredContext instantiateMapredContext() {
        Configuration conf = UDFContext.getUDFContext().getJobConf();
        boolean isMap = conf.getBoolean("mapred.task.is.map", false);
        if (conf.get("exectype").startsWith("TEZ")) {
            isMap = true;
            HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, (String)"tez");
        }
        MapredContext context = MapredContext.init((boolean)isMap, (JobConf)new JobConf(UDFContext.getUDFContext().getJobConf()));
        context.setReporter((Reporter)new HiveReporter(PigStatusReporter.getInstance()));
        return context;
    }

    @Override
    public List<String> getShipFiles() {
        Class<?> hadoopVersionShimsClass;
        String hadoopVersion = "20S";
        if (Utils.isHadoop23() || Utils.isHadoop2()) {
            hadoopVersion = "23";
        }
        try {
            hadoopVersionShimsClass = Class.forName("org.apache.hadoop.hive.shims.Hadoop" + hadoopVersion + "Shims");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find Hadoop" + hadoopVersion + "ShimsClass in classpath");
        }
        List<String> files = FuncUtils.getShipFiles(new Class[]{GenericUDF.class, PrimitiveObjectInspector.class, HiveConf.class, Serializer.class, ShimLoader.class, hadoopVersionShimsClass, HadoopShimsSecure.class, Collector.class});
        return files;
    }

    protected static String getErrorMessage(Class c) {
        StringBuffer message = new StringBuffer("Please declare " + c.getName() + " as ");
        if (UDF.class.isAssignableFrom(c) || GenericUDF.class.isAssignableFrom(c)) {
            message.append(HiveUDF.class.getName());
        } else if (GenericUDTF.class.isAssignableFrom(c)) {
            message.append(HiveUDTF.class.getName());
        } else if (UDAF.class.isAssignableFrom(c) || GenericUDAFResolver.class.isAssignableFrom(c)) {
            message.append(HiveUDAF.class.getName());
        } else {
            message = new StringBuffer(c.getName() + " is not Hive UDF");
        }
        return message.toString();
    }

    protected static class HiveReporter
    implements Reporter {
        PigStatusReporter rep;

        HiveReporter(PigStatusReporter rep) {
            this.rep = rep;
        }

        public void setStatus(String s) {
            this.rep.setStatus(s);
        }

        public void progress() {
            this.rep.progress();
        }

        public Counters.Counter getCounter(Enum<?> name) {
            try {
                Counters counters = new Counters();
                counters.incrCounter(name, this.rep.getCounter(name).getValue());
                return counters.findCounter(name);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Counters.Counter getCounter(String group, String name) {
            try {
                Counters counters = new Counters();
                counters.incrCounter(group, name, this.rep.getCounter(group, name).getValue());
                return counters.findCounter(group, name);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void incrCounter(Enum<?> key, long amount) {
            this.rep.incrCounter(key, amount);
        }

        public void incrCounter(String group, String counter, long amount) {
            this.rep.incrCounter(group, counter, amount);
        }

        public InputSplit getInputSplit() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("NULL reporter has no input");
        }

        public float getProgress() {
            return 0.0f;
        }
    }

    protected static class ConstantObjectInspectInfo {
        ConstantObjectInspector[] constants;

        protected ConstantObjectInspectInfo() {
        }

        static ConstantObjectInspectInfo parse(String params) throws IOException {
            ConstantObjectInspectInfo info = new ConstantObjectInspectInfo();
            Object constant = Utils.parseConstant(params = params.replaceAll("\"", "'"));
            if (DataType.findType(constant) == 110) {
                Tuple t = (Tuple)constant;
                info.constants = new ConstantObjectInspector[t.size()];
                for (int i = 0; i < t.size(); ++i) {
                    if (t.get(i) == null) continue;
                    info.constants[i] = HiveUtils.getConstantObjectInspector(t.get(i));
                }
            } else {
                info.constants = new ConstantObjectInspector[1];
                info.constants[0] = HiveUtils.getConstantObjectInspector(constant);
            }
            return info;
        }

        boolean isEmpty() {
            return this.constants == null;
        }

        int size() {
            return this.constants.length;
        }

        ConstantObjectInspector get(int i) {
            return this.constants[i];
        }

        void injectConstantObjectInspector(StructObjectInspector inputObjectInspector) {
            if (!this.isEmpty()) {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i) == null) continue;
                    StructField origField = (StructField)inputObjectInspector.getAllStructFieldRefs().get(i);
                    HiveUtils.Field newfield = new HiveUtils.Field(origField.getFieldName(), (ObjectInspector)this.get(i), i);
                    inputObjectInspector.getAllStructFieldRefs().set(i, newfield);
                }
            }
        }
    }
}

