/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.web;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMWebController
extends Controller {
    private static final Logger LOG = LoggerFactory.getLogger(AMWebController.class);
    static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    static final String ALLOWED_METHODS = "GET, HEAD";
    static final String ALLOWED_HEADERS = "X-Requested-With,Content-Type,Accept,Origin";
    static final String DAG_PROGRESS = "dagProgress";
    static final String VERTEX_PROGRESS = "vertexProgress";
    static final String VERTEX_PROGRESSES = "vertexProgresses";
    static final int MAX_VERTICES_QUERIED = 100;
    private AppContext appContext;
    private String historyUrl;

    @Inject
    public AMWebController(Controller.RequestContext requestContext, AppContext appContext, @Named(value="TezUIHistoryURL") String historyUrl) {
        super(requestContext);
        this.appContext = appContext;
        this.historyUrl = historyUrl;
    }

    public void index() {
        this.ui();
    }

    public void ui() {
        this.render(StaticAMView.class);
    }

    public void main() {
        this.ui();
    }

    public void about() {
        this.renderJSON("Tez AM UI WebServices");
    }

    @VisibleForTesting
    public void setCorsHeaders() {
        String origin;
        HttpServletResponse res;
        block3: {
            res = this.response();
            String historyUrlBase = this.appContext.getAMConf().get("tez.tez-ui.history-url.base", "");
            origin = null;
            try {
                URL url = new URL(historyUrlBase);
                origin = url.getProtocol() + "://" + url.getAuthority();
            }
            catch (MalformedURLException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Invalid url set for tez history url base: " + historyUrlBase, (Throwable)e);
            }
        }
        if (origin != null) {
            res.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, origin);
        }
        res.setHeader(ACCESS_CONTROL_ALLOW_METHODS, ALLOWED_METHODS);
        res.setHeader(ACCESS_CONTROL_ALLOW_CREDENTIALS, Boolean.TRUE.toString());
        res.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, ALLOWED_HEADERS);
        res.setHeader(ACCESS_CONTROL_MAX_AGE, "1800");
    }

    void sendErrorResponse(int sc, String msg, Exception e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(msg, (Throwable)e);
        }
        try {
            this.response().sendError(sc, msg);
        }
        catch (IOException e1) {
            throw new WebAppException((Throwable)e);
        }
    }

    @VisibleForTesting
    static boolean _hasAccess(UserGroupInformation callerUGI, AppContext appContext) {
        if (callerUGI == null) {
            return !appContext.getAMACLManager().isAclsEnabled();
        }
        return appContext.getAMACLManager().checkDAGViewAccess(callerUGI);
    }

    public boolean hasAccess() {
        String remoteUser = this.request().getRemoteUser();
        UserGroupInformation callerUGI = null;
        if (remoteUser != null && !remoteUser.isEmpty()) {
            callerUGI = UserGroupInformation.createRemoteUser((String)remoteUser);
        }
        return AMWebController._hasAccess(callerUGI, this.appContext);
    }

    public void getDagProgress() {
        int dagID;
        this.setCorsHeaders();
        if (!this.hasAccess()) {
            this.sendErrorResponse(401, "Access denied for user: " + this.request().getRemoteUser(), null);
            return;
        }
        try {
            dagID = this.getQueryParamInt("dagID");
        }
        catch (NumberFormatException e) {
            this.sendErrorResponse(400, "Invalid dag id:", e);
            return;
        }
        DAG currentDAG = this.appContext.getCurrentDAG();
        if (currentDAG == null || dagID != currentDAG.getID().getId()) {
            this.sendErrorResponse(404, "Not current Dag: " + dagID, null);
            return;
        }
        HashMap<String, ProgressInfo> result = new HashMap<String, ProgressInfo>();
        result.put(DAG_PROGRESS, new ProgressInfo(currentDAG.getID().toString(), currentDAG.getProgress()));
        this.renderJSON(result);
    }

    public void getVertexProgress() {
        int vertexID;
        int dagID;
        this.setCorsHeaders();
        if (!this.hasAccess()) {
            this.sendErrorResponse(401, "Access denied for user: " + this.request().getRemoteUser(), null);
            return;
        }
        try {
            dagID = this.getQueryParamInt("dagID");
            vertexID = this.getQueryParamInt("vertexID");
        }
        catch (NumberFormatException e) {
            this.sendErrorResponse(400, "Invalid dag or vertex id", e);
            return;
        }
        DAG currentDAG = this.appContext.getCurrentDAG();
        if (currentDAG == null || currentDAG.getID().getId() != dagID) {
            this.sendErrorResponse(404, "Not current Dag: " + dagID, null);
            return;
        }
        TezVertexID tezVertexID = TezVertexID.getInstance((TezDAGID)currentDAG.getID(), (int)vertexID);
        Vertex vertex = currentDAG.getVertex(tezVertexID);
        if (vertex == null) {
            this.sendErrorResponse(404, "vertex not found: " + vertexID, null);
            return;
        }
        HashMap<String, ProgressInfo> result = new HashMap<String, ProgressInfo>();
        result.put(VERTEX_PROGRESS, new ProgressInfo(tezVertexID.toString(), vertex.getProgress()));
        this.renderJSON(result);
    }

    Collection<Vertex> getVerticesByIdx(DAG dag, Collection<Integer> indexes) {
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(indexes.size());
        TezDAGID tezDAGID = dag.getID();
        for (Integer idx : indexes) {
            Vertex vertex;
            TezVertexID tezVertexID = TezVertexID.getInstance((TezDAGID)tezDAGID, (int)idx);
            if (tezVertexID == null || (vertex = dag.getVertex(tezVertexID)) == null) continue;
            vertices.add(vertex);
        }
        return vertices;
    }

    int getQueryParamInt(String name) throws NumberFormatException {
        String valueStr = this.$(name).trim();
        return Integer.parseInt(valueStr);
    }

    public void getVertexProgresses() {
        int dagID;
        this.setCorsHeaders();
        if (!this.hasAccess()) {
            this.sendErrorResponse(401, "Access denied for user: " + this.request().getRemoteUser(), null);
            return;
        }
        ArrayList<Integer> vertexIDs = new ArrayList<Integer>();
        try {
            dagID = this.getQueryParamInt("dagID");
            for (String vertexIDStr : this.$("vertexID").trim().split(",", 100)) {
                vertexIDs.add(Integer.parseInt(vertexIDStr));
            }
        }
        catch (NumberFormatException e) {
            this.sendErrorResponse(400, "Invalid dag or vertices id", e);
            return;
        }
        DAG currentDAG = this.appContext.getCurrentDAG();
        if (currentDAG == null || currentDAG.getID().getId() != dagID) {
            this.sendErrorResponse(404, "Not current Dag: " + dagID, null);
            return;
        }
        Collection<Vertex> vertices = vertexIDs.isEmpty() ? currentDAG.getVertices().values() : this.getVerticesByIdx(currentDAG, vertexIDs);
        ArrayList<ProgressInfo> progresses = new ArrayList<ProgressInfo>(vertices.size());
        for (Vertex vertex : vertices) {
            progresses.add(new ProgressInfo(vertex.getVertexId().toString(), vertex.getProgress()));
        }
        HashMap<String, ArrayList<ProgressInfo>> result = new HashMap<String, ArrayList<ProgressInfo>>();
        result.put(VERTEX_PROGRESSES, progresses);
        this.renderJSON(result);
    }

    @VisibleForTesting
    public void renderJSON(Object object) {
        super.renderJSON(object);
    }

    @VisibleForTesting
    static class ProgressInfo {
        private String id;
        private float progress;

        public float getProgress() {
            return this.progress;
        }

        public String getId() {
            return this.id;
        }

        public ProgressInfo(String id, float progress) {
            this.id = id;
            this.progress = progress;
        }
    }

    public static class StaticAMView
    extends View {
        @Inject
        AppContext appContext;
        @Inject
        @Named(value="TezUIHistoryURL")
        String historyUrl;

        public void render() {
            this.response().setContentType("text/html; charset=UTF-8");
            PrintWriter pw = this.writer();
            pw.write("<html>");
            pw.write("<head>");
            pw.write("<meta charset=\"utf-8\">");
            pw.write("<title>Redirecting to Tez UI</title>");
            pw.write("</head>");
            pw.write("<body>");
            if (this.historyUrl == null || this.historyUrl.isEmpty()) {
                pw.write("<h1>Tez UI Url is not defined.</h1><p>To enable tracking url pointing to Tez UI, set the config <b>tez.tez-ui.history-url.base</b> in the tez-site.xml.</p>");
            } else {
                pw.write("<h1>Redirecting to Tez UI</h1>. <p>If you are not redirected shortly, click <a href='" + this.historyUrl + "'><b>here</b></a></p>");
                pw.write("<script type='text/javascript'>setTimeout(function() { window.location.replace('" + this.historyUrl + "');" + "}, 0); </script>");
            }
            pw.write("</body>");
            pw.write("</html>");
            pw.flush();
        }
    }
}

