/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.impl;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.logging.HistoryLoggingService;
import org.apache.tez.dag.history.logging.impl.HistoryEventJsonConversion;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHistoryLoggingService
extends HistoryLoggingService {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleHistoryLoggingService.class);
    private Path logFileLocation;
    private FileSystem logFileFS;
    private FSDataOutputStream outputStream;
    private LinkedBlockingQueue<DAGHistoryEvent> eventQueue = new LinkedBlockingQueue();
    public static final String RECORD_SEPARATOR = "\u0001" + System.getProperty("line.separator");
    public static final String LOG_FILE_NAME_PREFIX = "history.txt";
    private Thread eventHandlingThread;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private int consecutiveErrors = 0;
    private int maxErrors;
    private boolean loggingDisabled = false;

    public SimpleHistoryLoggingService() {
        super(SimpleHistoryLoggingService.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        String logDirPath = conf.get("tez.simple.history.logging.dir");
        String logFileName = "history.txt." + this.appContext.getApplicationAttemptId();
        if (logDirPath == null || logDirPath.isEmpty()) {
            String logDir = this.appContext.getLogDirs()[new Random().nextInt(this.appContext.getLogDirs().length)];
            LOG.info("Log file location for SimpleHistoryLoggingService not specified, defaulting to containerLogDir=" + logDir);
            this.logFileFS = FileSystem.getLocal((Configuration)conf).getRawFileSystem();
            Path p = logDir != null ? new Path(logDir, logFileName) : new Path(logFileName);
            this.logFileLocation = p;
        } else {
            LOG.info("Using configured log file location for SimpleHistoryLoggingService logDirPath=" + logDirPath);
            Path p = new Path(logDirPath);
            this.logFileFS = p.getFileSystem(conf);
            if (!this.logFileFS.exists(p)) {
                this.logFileFS.mkdirs(p);
            }
            this.logFileLocation = new Path(this.logFileFS.resolvePath(p), logFileName);
        }
        this.maxErrors = conf.getInt("tez.simple.history.max.errors", 10);
        LOG.info("Initializing SimpleHistoryLoggingService, logFileLocation=" + this.logFileLocation + ", maxErrors=" + this.maxErrors);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        LOG.info("Starting SimpleHistoryLoggingService");
        this.outputStream = this.logFileFS.create(this.logFileLocation, true);
        this.eventHandlingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!SimpleHistoryLoggingService.this.stopped.get() && !Thread.currentThread().isInterrupted()) {
                    DAGHistoryEvent event;
                    try {
                        event = (DAGHistoryEvent)SimpleHistoryLoggingService.this.eventQueue.take();
                    }
                    catch (InterruptedException e) {
                        LOG.info("EventQueue take interrupted. Returning");
                        return;
                    }
                    SimpleHistoryLoggingService.this.handleEvent(event);
                }
            }
        }, "HistoryEventHandlingThread");
        this.eventHandlingThread.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        DAGHistoryEvent event;
        LOG.info("Stopping SimpleHistoryLoggingService, eventQueueBacklog=" + this.eventQueue.size());
        this.stopped.set(true);
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        while (!this.eventQueue.isEmpty() && (event = this.eventQueue.poll()) != null) {
            this.handleEvent(event);
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.hflush();
                this.outputStream.close();
            }
        }
        catch (IOException ioe) {
            LOG.warn("Failed to close output stream", (Throwable)ioe);
        }
        super.serviceStop();
    }

    @Override
    public void handle(DAGHistoryEvent event) {
        this.eventQueue.add(event);
    }

    private synchronized void handleEvent(DAGHistoryEvent event) {
        if (this.loggingDisabled) {
            return;
        }
        LOG.info("Writing event " + (Object)((Object)event.getHistoryEvent().getEventType()) + " to history file");
        try {
            try {
                JSONObject eventJson = HistoryEventJsonConversion.convertToJson(event.getHistoryEvent());
                this.outputStream.writeBytes(eventJson.toString());
                this.outputStream.writeBytes(RECORD_SEPARATOR);
            }
            catch (JSONException e) {
                LOG.warn("Failed to convert event to json", (Throwable)e);
            }
            this.consecutiveErrors = 0;
        }
        catch (IOException ioe) {
            ++this.consecutiveErrors;
            if (this.consecutiveErrors < this.maxErrors) {
                LOG.error("Failed to write to output stream, consecutiveErrorCount=" + this.consecutiveErrors, (Throwable)ioe);
            }
            this.loggingDisabled = true;
            LOG.error("Disabling SimpleHistoryLoggingService due to multiple errors,consecutive max errors reached, maxErrors=" + this.maxErrors);
        }
    }
}

