/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStreamingEvaluator;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.StringUtils;

@Description(name="avg", value="_FUNC_(x) - Returns the mean of a set of numbers")
public class GenericUDAFAverage
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog((String)GenericUDAFAverage.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        if (parameters[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
        }
        switch (((PrimitiveTypeInfo)parameters[0]).getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case TIMESTAMP: {
                return new GenericUDAFAverageEvaluatorDouble();
            }
            case DECIMAL: {
                return new GenericUDAFAverageEvaluatorDecimal();
            }
        }
        throw new UDFArgumentTypeException(0, "Only numeric or string type arguments are accepted but " + parameters[0].getTypeName() + " is passed.");
    }

    public static DecimalTypeInfo deriveSumFieldTypeInfo(int precision, int scale) {
        int intPart = precision - scale;
        intPart = Math.min(intPart + 10, 38 - scale);
        return TypeInfoFactory.getDecimalTypeInfo((int)(intPart + scale), (int)scale);
    }

    public static abstract class AbstractGenericUDAFAverageEvaluator<TYPE>
    extends GenericUDAFEvaluator {
        protected transient PrimitiveObjectInspector inputOI;
        private transient StructObjectInspector soi;
        private transient StructField countField;
        private transient StructField sumField;
        private LongObjectInspector countFieldOI;
        protected ObjectInspector sumFieldOI;
        protected transient Object[] partialResult;
        private boolean warned = false;

        protected abstract ObjectInspector getSumFieldJavaObjectInspector();

        protected abstract ObjectInspector getSumFieldWritableObjectInspector();

        protected abstract void doIterate(AverageAggregationBuffer<TYPE> var1, PrimitiveObjectInspector var2, Object var3);

        protected abstract void doMerge(AverageAggregationBuffer<TYPE> var1, Long var2, ObjectInspector var3, Object var4);

        protected abstract void doTerminatePartial(AverageAggregationBuffer<TYPE> var1);

        protected abstract Object doTerminate(AverageAggregationBuffer<TYPE> var1);

        protected abstract void doReset(AverageAggregationBuffer<TYPE> var1) throws HiveException;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            assert (parameters.length == 1);
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
            } else {
                this.soi = (StructObjectInspector)parameters[0];
                this.countField = this.soi.getStructFieldRef("count");
                this.sumField = this.soi.getStructFieldRef("sum");
                this.countFieldOI = (LongObjectInspector)this.countField.getFieldObjectInspector();
                this.sumFieldOI = this.sumField.getFieldObjectInspector();
                this.inputOI = (PrimitiveObjectInspector)this.soi.getStructFieldRef("input").getFieldObjectInspector();
            }
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                ArrayList<Object> foi = new ArrayList<Object>();
                foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                foi.add(this.getSumFieldWritableObjectInspector());
                foi.add(this.inputOI);
                ArrayList<String> fname = new ArrayList<String>();
                fname.add("count");
                fname.add("sum");
                fname.add("input");
                this.partialResult = new Object[2];
                this.partialResult[0] = new LongWritable(0L);
                return ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
            }
            return this.getSumFieldWritableObjectInspector();
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer aggregation) throws HiveException {
            this.doReset((AverageAggregationBuffer)aggregation);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer aggregation, Object[] parameters) throws HiveException {
            block4: {
                assert (parameters.length == 1);
                Object parameter = parameters[0];
                if (parameter != null) {
                    AverageAggregationBuffer averageAggregation = (AverageAggregationBuffer)aggregation;
                    try {
                        this.doIterate(averageAggregation, this.inputOI, parameter);
                    }
                    catch (NumberFormatException e) {
                        if (this.warned) break block4;
                        this.warned = true;
                        LOG.warn((Object)("Ignoring similar exceptions: " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
            }
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer aggregation) throws HiveException {
            this.doTerminatePartial((AverageAggregationBuffer)aggregation);
            return this.partialResult;
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer aggregation, Object partial) throws HiveException {
            if (partial != null) {
                this.doMerge((AverageAggregationBuffer)aggregation, this.countFieldOI.get(this.soi.getStructFieldData(partial, this.countField)), this.sumFieldOI, this.soi.getStructFieldData(partial, this.sumField));
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer aggregation) throws HiveException {
            return this.doTerminate((AverageAggregationBuffer)aggregation);
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class AverageAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            long count;
            double sum;

            AverageAgg() {
            }

            @Override
            public int estimate() {
                return 16;
            }
        }
    }

    private static class AverageAggregationBuffer<TYPE>
    implements GenericUDAFEvaluator.AggregationBuffer {
        private long count;
        private TYPE sum;

        private AverageAggregationBuffer() {
        }
    }

    public static class GenericUDAFAverageEvaluatorDecimal
    extends AbstractGenericUDAFAverageEvaluator<HiveDecimal> {
        @Override
        public void doReset(AverageAggregationBuffer<HiveDecimal> aggregation) throws HiveException {
            ((AverageAggregationBuffer)aggregation).count = 0L;
            ((AverageAggregationBuffer)aggregation).sum = HiveDecimal.ZERO;
        }

        @Override
        protected ObjectInspector getSumFieldJavaObjectInspector() {
            DecimalTypeInfo typeInfo = this.deriveResultDecimalTypeInfo();
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)typeInfo);
        }

        @Override
        protected ObjectInspector getSumFieldWritableObjectInspector() {
            DecimalTypeInfo typeInfo = this.deriveResultDecimalTypeInfo();
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo);
        }

        private DecimalTypeInfo deriveResultDecimalTypeInfo() {
            int prec = this.inputOI.precision();
            int scale = this.inputOI.scale();
            if (this.mode == GenericUDAFEvaluator.Mode.FINAL || this.mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                int intPart = prec - scale;
                scale = Math.min(scale + 4, 38 - intPart);
                return TypeInfoFactory.getDecimalTypeInfo((int)(intPart + scale), (int)scale);
            }
            return GenericUDAFAverage.deriveSumFieldTypeInfo(prec, scale);
        }

        @Override
        protected void doIterate(AverageAggregationBuffer<HiveDecimal> aggregation, PrimitiveObjectInspector oi, Object parameter) {
            HiveDecimal value = PrimitiveObjectInspectorUtils.getHiveDecimal((Object)parameter, (PrimitiveObjectInspector)oi);
            ((AverageAggregationBuffer)aggregation).count++;
            if (((AverageAggregationBuffer)aggregation).sum != null) {
                ((AverageAggregationBuffer)aggregation).sum = ((HiveDecimal)((AverageAggregationBuffer)aggregation).sum).add(value);
            }
        }

        @Override
        protected void doMerge(AverageAggregationBuffer<HiveDecimal> aggregation, Long partialCount, ObjectInspector sumFieldOI, Object partialSum) {
            HiveDecimal value = ((HiveDecimalObjectInspector)sumFieldOI).getPrimitiveJavaObject(partialSum);
            if (value == null) {
                ((AverageAggregationBuffer)aggregation).sum = null;
            }
            ((AverageAggregationBuffer)aggregation).count += partialCount;
            if (((AverageAggregationBuffer)aggregation).sum != null) {
                ((AverageAggregationBuffer)aggregation).sum = ((HiveDecimal)((AverageAggregationBuffer)aggregation).sum).add(value);
            }
        }

        @Override
        protected void doTerminatePartial(AverageAggregationBuffer<HiveDecimal> aggregation) {
            if (this.partialResult[1] == null && ((AverageAggregationBuffer)aggregation).sum != null) {
                this.partialResult[1] = new HiveDecimalWritable(HiveDecimal.ZERO);
            }
            ((LongWritable)this.partialResult[0]).set(((AverageAggregationBuffer)aggregation).count);
            if (((AverageAggregationBuffer)aggregation).sum != null) {
                ((HiveDecimalWritable)this.partialResult[1]).set((HiveDecimal)((AverageAggregationBuffer)aggregation).sum);
            } else {
                this.partialResult[1] = null;
            }
        }

        @Override
        protected Object doTerminate(AverageAggregationBuffer<HiveDecimal> aggregation) {
            if (((AverageAggregationBuffer)aggregation).count == 0L || ((AverageAggregationBuffer)aggregation).sum == null) {
                return null;
            }
            HiveDecimalWritable result = new HiveDecimalWritable(HiveDecimal.ZERO);
            result.set(((HiveDecimal)((AverageAggregationBuffer)aggregation).sum).divide(HiveDecimal.create((long)((AverageAggregationBuffer)aggregation).count)));
            return result;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            AverageAggregationBuffer result = new AverageAggregationBuffer();
            this.reset(result);
            return result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            BoundaryDef start = wFrmDef.getStart();
            BoundaryDef end = wFrmDef.getEnd();
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<HiveDecimalWritable, Object[]>((GenericUDAFEvaluator)this, start.getAmt(), end.getAmt()){

                @Override
                protected HiveDecimalWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    Object[] o;
                    AverageAggregationBuffer myagg = (AverageAggregationBuffer)ss.wrappedBuf;
                    HiveDecimal r = myagg.count == 0L ? null : (HiveDecimal)myagg.sum;
                    long cnt = myagg.count;
                    if (ss.numPreceding != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT && ss.numRows - ss.numFollowing >= ss.numPreceding + 1 && (o = (Object[])ss.intermediateVals.remove(0)) != null) {
                        HiveDecimal d = (HiveDecimal)o[0];
                        r = r == null ? null : r.subtract(d);
                        cnt -= ((Long)o[1]).longValue();
                    }
                    return r == null ? null : new HiveDecimalWritable(r.divide(HiveDecimal.create((long)cnt)));
                }

                @Override
                protected Object[] getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    Object[] objectArray;
                    AverageAggregationBuffer myagg = (AverageAggregationBuffer)ss.wrappedBuf;
                    if (myagg.count == 0L) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = myagg.sum;
                        objectArray = objectArray2;
                        objectArray2[1] = myagg.count;
                    }
                    return objectArray;
                }
            };
        }
    }

    public static class GenericUDAFAverageEvaluatorDouble
    extends AbstractGenericUDAFAverageEvaluator<Double> {
        @Override
        public void doReset(AverageAggregationBuffer<Double> aggregation) throws HiveException {
            ((AverageAggregationBuffer)aggregation).count = 0L;
            ((AverageAggregationBuffer)aggregation).sum = new Double(0.0);
        }

        @Override
        protected ObjectInspector getSumFieldJavaObjectInspector() {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }

        @Override
        protected ObjectInspector getSumFieldWritableObjectInspector() {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }

        @Override
        protected void doIterate(AverageAggregationBuffer<Double> aggregation, PrimitiveObjectInspector oi, Object parameter) {
            double value = PrimitiveObjectInspectorUtils.getDouble((Object)parameter, (PrimitiveObjectInspector)oi);
            ((AverageAggregationBuffer)aggregation).count++;
            AverageAggregationBuffer<Double> averageAggregationBuffer = aggregation;
            ((AverageAggregationBuffer)averageAggregationBuffer).sum = (Double)((AverageAggregationBuffer)averageAggregationBuffer).sum + value;
        }

        @Override
        protected void doMerge(AverageAggregationBuffer<Double> aggregation, Long partialCount, ObjectInspector sumFieldOI, Object partialSum) {
            double value = ((DoubleObjectInspector)sumFieldOI).get(partialSum);
            ((AverageAggregationBuffer)aggregation).count += partialCount;
            AverageAggregationBuffer<Double> averageAggregationBuffer = aggregation;
            ((AverageAggregationBuffer)averageAggregationBuffer).sum = (Double)((AverageAggregationBuffer)averageAggregationBuffer).sum + value;
        }

        @Override
        protected void doTerminatePartial(AverageAggregationBuffer<Double> aggregation) {
            if (this.partialResult[1] == null) {
                this.partialResult[1] = new DoubleWritable(0.0);
            }
            ((LongWritable)this.partialResult[0]).set(((AverageAggregationBuffer)aggregation).count);
            ((DoubleWritable)this.partialResult[1]).set(((Double)((AverageAggregationBuffer)aggregation).sum).doubleValue());
        }

        @Override
        protected Object doTerminate(AverageAggregationBuffer<Double> aggregation) {
            if (((AverageAggregationBuffer)aggregation).count == 0L) {
                return null;
            }
            DoubleWritable result = new DoubleWritable(0.0);
            result.set((Double)((AverageAggregationBuffer)aggregation).sum / (double)((AverageAggregationBuffer)aggregation).count);
            return result;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            AverageAggregationBuffer result = new AverageAggregationBuffer();
            this.reset(result);
            return result;
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            BoundaryDef start = wFrmDef.getStart();
            BoundaryDef end = wFrmDef.getEnd();
            return new GenericUDAFStreamingEvaluator.SumAvgEnhancer<DoubleWritable, Object[]>((GenericUDAFEvaluator)this, start.getAmt(), end.getAmt()){

                @Override
                protected DoubleWritable getNextResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    Object[] o;
                    AverageAggregationBuffer myagg = (AverageAggregationBuffer)ss.wrappedBuf;
                    Double r = myagg.count == 0L ? null : (Double)myagg.sum;
                    long cnt = myagg.count;
                    if (ss.numPreceding != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT && ss.numRows - ss.numFollowing >= ss.numPreceding + 1 && (o = (Object[])ss.intermediateVals.remove(0)) != null) {
                        Double d = (Double)o[0];
                        r = r == null ? null : Double.valueOf(r - d);
                        cnt -= ((Long)o[1]).longValue();
                    }
                    return r == null ? null : new DoubleWritable(r / (double)cnt);
                }

                @Override
                protected Object[] getCurrentIntermediateResult(GenericUDAFStreamingEvaluator.SumAvgEnhancer.SumAvgStreamingState ss) throws HiveException {
                    Object[] objectArray;
                    AverageAggregationBuffer myagg = (AverageAggregationBuffer)ss.wrappedBuf;
                    if (myagg.count == 0L) {
                        objectArray = null;
                    } else {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = new Double((Double)myagg.sum);
                        objectArray = objectArray2;
                        objectArray2[1] = myagg.count;
                    }
                    return objectArray;
                }
            };
        }
    }
}

