/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.impl.util.ObjectSerializer;

public class UDFContext {
    private Configuration jconf = null;
    private HashMap<UDFContextKey, Properties> udfConfs = new HashMap();
    private Properties clientSysProps;
    static final String CLIENT_SYS_PROPS = "pig.client.sys.props";
    static final String UDF_CONTEXT = "pig.udf.context";
    private static ThreadLocal<UDFContext> tss = new ThreadLocal<UDFContext>(){

        @Override
        public UDFContext initialValue() {
            return new UDFContext();
        }
    };

    private UDFContext() {
    }

    public static UDFContext getUDFContext() {
        return tss.get();
    }

    public static void setUdfContext(UDFContext udfContext) {
        tss.set(udfContext);
    }

    public static void staticDataCleanup() {
        tss = new ThreadLocal<UDFContext>(){

            @Override
            public UDFContext initialValue() {
                return new UDFContext();
            }
        };
    }

    HashMap<UDFContextKey, Properties> getUdfConfs() {
        return this.udfConfs;
    }

    public void setClientSystemProps(Properties properties) {
        this.clientSysProps = properties;
    }

    public Properties getClientSystemProps() {
        return this.clientSysProps;
    }

    public void addJobConf(Configuration conf) {
        this.jconf = conf;
    }

    public Configuration getJobConf() {
        if (this.jconf != null) {
            return new Configuration(this.jconf);
        }
        return null;
    }

    public Properties getUDFProperties(Class c, String[] args) {
        UDFContextKey k = this.generateKey(c, args);
        Properties p = this.udfConfs.get(k);
        if (p == null) {
            p = new Properties();
            this.udfConfs.put(k, p);
        }
        return p;
    }

    public Properties getUDFProperties(Class c) {
        UDFContextKey k = this.generateKey(c, null);
        Properties p = this.udfConfs.get(k);
        if (p == null) {
            p = new Properties();
            this.udfConfs.put(k, p);
        }
        return p;
    }

    public void serialize(Configuration conf) throws IOException {
        conf.set(UDF_CONTEXT, ObjectSerializer.serialize(this.udfConfs));
        conf.set(CLIENT_SYS_PROPS, ObjectSerializer.serialize(this.clientSysProps));
    }

    public void deserialize() throws IOException {
        this.udfConfs = (HashMap)ObjectSerializer.deserialize(this.jconf.get(UDF_CONTEXT));
        this.clientSysProps = (Properties)ObjectSerializer.deserialize(this.jconf.get(CLIENT_SYS_PROPS));
    }

    private UDFContextKey generateKey(Class<?> c, String[] args) {
        return new UDFContextKey(c.getName(), args);
    }

    public void reset() {
        this.udfConfs.clear();
    }

    public boolean isUDFConfEmpty() {
        return this.udfConfs.isEmpty();
    }

    public boolean isFrontend() {
        return this.jconf == null || this.jconf.get("mapred.task.id") == null && this.jconf.get("mapreduce.job.application.attempt.id") == null;
    }

    public UDFContext clone() {
        UDFContext other = new UDFContext();
        other.clientSysProps = this.clientSysProps;
        other.jconf = this.jconf;
        other.udfConfs = this.udfConfs;
        return other;
    }

    static class UDFContextKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String className;
        private String[] args;

        UDFContextKey(String className, String[] args) {
            this.className = className;
            this.args = args;
        }

        String getClassName() {
            return this.className;
        }

        String[] getArgs() {
            return this.args;
        }

        public String toString() {
            return "UDFContextKey [className=" + this.className + ", args=" + Arrays.toString(this.args) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.args);
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UDFContextKey other = (UDFContextKey)obj;
            if (!Arrays.equals(this.args, other.args)) {
                return false;
            }
            return !(this.className == null ? other.className != null : !this.className.equals(other.className));
        }
    }
}

