/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;
import org.apache.trevni.avro.RandomData;

public class CreateRandomFileTool
implements Tool {
    @Override
    public String getName() {
        return "random";
    }

    @Override
    public String getShortDescription() {
        return "Creates a file with randomly generated instances of a schema.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec count = p.accepts("count", "Record Count").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec codec = p.accepts("codec", "Compression codec").withRequiredArg().defaultsTo((Object)"null", (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec file = p.accepts("schema-file", "Schema File").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec inschema = p.accepts("schema", "Schema").withOptionalArg().ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        if (opts.nonOptionArguments().size() != 1) {
            err.println("Usage: outFile (filename or '-' for stdout)");
            p.printHelpOn((OutputStream)err);
            return 1;
        }
        args = opts.nonOptionArguments();
        String schemastr = (String)inschema.value(opts);
        String schemafile = (String)file.value(opts);
        if (schemastr == null && schemafile == null) {
            err.println("Need input schema (--schema-file) or (--schema)");
            p.printHelpOn((OutputStream)err);
            return 1;
        }
        Schema schema = schemafile != null ? new Schema.Parser().parse(Util.openFromFS(schemafile)) : new Schema.Parser().parse(schemastr);
        DataFileWriter writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
        writer.setCodec(CodecFactory.fromString((String)((String)codec.value(opts))));
        writer.create(schema, (OutputStream)Util.fileOrStdout((String)args.get(0), out));
        for (Object datum : new RandomData(schema, ((Integer)count.value(opts)).intValue())) {
            writer.append(datum);
        }
        writer.close();
        return 0;
    }
}

