/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;

public class CreateSnapshot
extends AbstractHBaseTool {
    private String tableName = null;
    private String snapshotName = null;
    private String snapshotType = null;

    public static void main(String[] args) {
        new CreateSnapshot().doStaticMain(args);
    }

    @Override
    protected void addOptions() {
        this.addRequiredOptWithArg("t", "table", "The name of the table");
        this.addRequiredOptWithArg("n", "name", "The name of the created snapshot");
        this.addOptWithArg("s", "snapshot_type", "Snapshot Type. FLUSH is default. Posible values are " + Arrays.toString(HBaseProtos.SnapshotDescription.Type.values()));
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        this.tableName = cmd.getOptionValue('t');
        this.snapshotName = cmd.getOptionValue('n');
        this.snapshotType = cmd.getOptionValue('s');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() throws Exception {
        HBaseAdmin admin = null;
        try {
            admin = new HBaseAdmin(this.conf);
            HBaseProtos.SnapshotDescription.Type type = HBaseProtos.SnapshotDescription.Type.FLUSH;
            if (this.snapshotType != null) {
                type = HBaseProtos.SnapshotDescription.Type.valueOf((String)this.snapshotName.toUpperCase());
            }
            admin.snapshot(this.snapshotName, TableName.valueOf((String)this.tableName), type);
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            if (admin != null) {
                admin.close();
            }
        }
        return 0;
    }
}

