/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.tabletserver.mastermessage;

import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.TabletSplit;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.server.tabletserver.mastermessage.MasterMessage;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;

public class SplitReportMessage
implements MasterMessage {
    Map<KeyExtent, Text> extents;
    KeyExtent old_extent;

    public SplitReportMessage(KeyExtent old_extent, Map<KeyExtent, Text> newExtents) {
        this.old_extent = old_extent;
        this.extents = new TreeMap<KeyExtent, Text>(newExtents);
    }

    public SplitReportMessage(KeyExtent old_extent, KeyExtent ne1, Text np1, KeyExtent ne2, Text np2) {
        this.old_extent = old_extent;
        this.extents = new TreeMap<KeyExtent, Text>();
        this.extents.put(ne1, np1);
        this.extents.put(ne2, np2);
    }

    @Override
    public void send(TCredentials credentials, String serverName, MasterClientService.Iface client) throws TException, ThriftSecurityException {
        TabletSplit split = new TabletSplit();
        split.oldTablet = this.old_extent.toThrift();
        split.newTablets = Translator.translate(this.extents.keySet(), (Translator)Translator.KET);
        client.reportSplitExtent(Tracer.traceInfo(), credentials, serverName, split);
    }
}

